% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqs.R
\name{as_seqs}
\alias{as_seqs}
\alias{as_seqs.tbl_df}
\title{Compute a layout for sequence data}
\usage{
as_seqs(x, ...)

\method{as_seqs}{tbl_df}(x, everything = TRUE, ...)
}
\arguments{
\item{x}{an object convertible to a sequence layout}

\item{...}{pass through to \code{layout_seqs()}}

\item{everything}{set to FALSE to drop optional columns}
}
\value{
an tbl_df with plot coordinates
}
\description{
Read sequence data of multiple genomes (contigs, chromosomes, ...) into a
tidy dataframe and augment it with layout information necessary for plotting.
}
\details{
Obligatory columns are \code{seq_id}, \code{bin_id} and \code{length}.
}
\section{Methods (by class)}{
\itemize{
\item \code{as_seqs(tbl_df)}: Convert a list of tibbles into a seq layout

}}
\examples{
chr <- tibble::tibble(
  seq_id = c("a1", "b1", "b2"),
  bin_id = c(rep("A", 1), rep("B", 2)),
  length = c(5000, 3000, 1400)
)

as_seqs(chr)
}
\keyword{internal}
