% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conveniences.R
\name{weave_factors}
\alias{weave_factors}
\title{Bind together factors}
\usage{
weave_factors(..., drop = TRUE, sep = ".", replaceNA = TRUE)
}
\arguments{
\item{...}{The vectors}

\item{drop}{A \code{logical} of length 1 which when \code{TRUE} will remove
combinations of factors not occurring in the input data.}

\item{sep}{A \code{character} of length 1 with a string to delimit the new
level labels.}

\item{replaceNA}{A \code{logical} of length 1: replace \code{NA} values with
empty strings?}
}
\value{
A \code{factor} representing combinations of input factors.
}
\description{
Computes a new factor out of combinations of input factors.
}
\details{
\code{weave_factors()} broadly resembles \code{interaction(..., lex.order = TRUE)}, with a slightly altered approach to non-factor inputs.
In other words, this function orders the new levels such that the levels of
the first input variable in \code{...} is given priority over the second
input, the second input has priority over the third, etc.

This function treats non-factor inputs as if their levels were
\code{unique(as.character(x))}, wherein \code{x} represents an input.
}
\examples{
f1 <- c("banana", "apple", "apple", "kiwi")
f2 <- factor(c(1, 1:3), labels = c("house", "cat", "dog"))

# Notice the difference in level ordering between the following:
interaction(f1, f2, drop = TRUE, lex.order = TRUE)
interaction(f1, f2, drop = TRUE, lex.order = FALSE)
weave_factors(f1, f2)

# The difference is in how characters are interpreted
# The following are equivalent
interaction(f1, f2, drop = TRUE, lex.order = TRUE)
weave_factors(as.factor(f1), f2)
}
\seealso{
\code{\link[=interaction]{interaction()}}
}
