% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_axis_manual.R
\name{guide_axis_manual}
\alias{guide_axis_manual}
\title{Manual axis}
\usage{
guide_axis_manual(
  title = waiver(),
  breaks = waiver(),
  labels = waiver(),
  label_family = NULL,
  label_face = NULL,
  label_colour = NULL,
  label_size = NULL,
  label_hjust = NULL,
  label_vjust = NULL,
  label_lineheight = NULL,
  label_color = NULL,
  label_margin = NULL,
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  order = 0,
  colour = NULL,
  color = NULL,
  trunc_lower = NULL,
  trunc_upper = NULL,
  position = waiver()
)
}
\arguments{
\item{title}{A character string or expression indicating a title of guide.
If \code{NULL}, the title is not shown. By default
(\code{\link[ggplot2:waiver]{waiver()}}), the name of the scale object or the name
specified in \code{\link[ggplot2:labs]{labs()}} is used for the title.}

\item{breaks}{One of the following ways to parametrise the tick and label
positions:
\itemize{
\item \code{NULL} to draw no ticks and labels.
\item \code{waiver()} for the default breaks computed by the scale (default).
\item A \code{numeric} vector for continuous or discrete scales, or a \code{character}
vector for discrete scales.
\item A \code{function} that takes the limits as input and returns breaks as output.
Also accepts rlang \link[rlang:as_function]{lambda} notation.
\item A \code{\link[grid:unit]{unit}} vector for setting data-independent
breaks.
}}

\item{labels}{One of the following ways to dictate the labels:
\itemize{
\item \code{NULL} to draw no labels.
\item \code{waiver()} for the default labels computed by the scale on the breaks
(default). Note that a scale with non-identity transformation is unlikely
to graciously handle breaks defined in grid-units.
\item A \code{character} vector giving
\item A \code{function} that takes the breaks as input and returns labels as output.
Also accepts rlang \link[rlang:as_function]{lambda} notation.
}}

\item{label_family, label_face, label_colour, label_size, label_hjust, label_vjust, label_lineheight, label_color, label_margin}{Arguments passed down to the label constructor. See
\code{\link[ggplot2:element]{element_text()}} arguments, which these
arguments mirror with the \code{label_}-prefix. With the exception of
\code{label_margin}, the other \verb{label_*} arguments are assumed be parallel to
(the result of) the \code{labels} argument and will be recycled with
\code{\link[base:rep]{rep_len()}} as necessary. By default, these parameters
are taken from the theme.}

\item{check.overlap}{silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in \code{\link[ggplot2:theme]{theme()}} / \code{\link[ggplot2:element_text]{element_text()}},
this also uses some heuristics to automatically pick the \code{hjust} and \code{vjust} that
you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{order}{Used to determine the order of the guides (left-to-right,
top-to-bottom), if more than one  guide must be drawn at the same location.}

\item{colour, color}{A \code{character(1)} with a valid colour for colouring the
axis text, axis ticks and axis line. Overrules the colour assigned by the
theme.}

\item{trunc_lower, trunc_upper}{The lower and upper range of the truncated
axis:
\itemize{
\item \code{NULL} to not perform any truncation.
\item A \code{function} that takes the break positions as input and returns the lower
or upper boundary. Note that also for discrete scales, positions are the
mapped positions as \code{numeric}.
\item A \code{numeric} value in data units for the lower and upper boundaries.
\item A \code{unit} object.
}}

\item{position}{Where this guide should be drawn: one of top, bottom,
left, or right.}
}
\value{
An \emph{axis_manual} guide class object.
}
\description{
This axis allows a greater degree of control than the default axes guides. In
particular, this axis allows setting break positions and labels independently
from the scale and is not bound by the same constraints as secondary axes.
Additionally, label attributes may be set in parallel to the labels
themselves, circumventing the unsupported vectorised input to
\code{element_text()}.
}
\examples{
ggplot(iris, aes(Species, Sepal.Width)) +
  geom_boxplot(aes(fill = Species)) +
  guides(x = guide_axis_manual(
    label_colour = scales::hue_pal()(3),
    label_face = c("bold", "italic", "plain"),
    labels = toupper
  ))

# Using the manual axis to annotate some specific point
ggplot(pressure, aes(temperature, pressure)) +
  geom_point() +
  geom_hline(yintercept = 300, linetype = 2, colour = "blue") +
  guides(y.sec = guide_axis_manual(breaks = 300, labels = "some\nthreshold",
                                   label_colour = "blue"))
}
\seealso{
Other axis-guides: 
\code{\link{guide_axis_logticks}()},
\code{\link{guide_axis_minor}()},
\code{\link{guide_axis_nested}()},
\code{\link{guide_axis_scalebar}()},
\code{\link{guide_axis_truncated}()}
}
\concept{axis-guides}
