% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_theodensity.R
\name{stat_theodensity}
\alias{stat_theodensity}
\title{Fitted theoretical density}
\usage{
stat_theodensity(
  mapping = NULL,
  data = NULL,
  geom = "line",
  position = "identity",
  ...,
  distri = "norm",
  n = 512,
  fix.arg = NULL,
  start.arg = NULL,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{Use to override the default geom for \code{stat_theodensity}.}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{distri}{A \code{character} of length 1 naming a distribution without
prefix. See details.}

\item{n}{An \code{integer} of length 1 with the number of equally spaced
points at which the density function is evaluated. Ignored if distribution
is discrete.}

\item{fix.arg}{An optional named list giving values of fixed parameters of
the named distribution. Parameters with fixed value are not estimated by
maximum likelihood procedures.}

\item{start.arg}{A named list giving initial values of parameters for the
named distribution. This argument may be omitted (default) for some
distributions for which reasonable starting values are computed.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \emph{Layer} ggproto object.
}
\description{
Estimates the parameters of a given distribution and evaluates
the probability density function with these parameters. This can be useful
for comparing histograms or kernel density estimates against a theoretical
distribution.
}
\details{
Valid \code{distri} arguments are the names of distributions for
which there exists a density function. The names should be given without a
prefix (typically 'd', 'r', 'q' and 'r'). For example: \code{"norm"} for
the normal distribution and \code{"nbinom"} for the negative binomial
distribution. Take a look at \code{\link[stats:Distributions]{distributions()}} in the
\pkg{stats} package for an overview.

There are a couple of distribution for which there exist no reasonable
starting values, such as the Student t-distribution and the F-distribution.
In these cases, it would probably be wise to provide reasonable starting
values as a named list to the \code{start.arg} argument. When estimating a
binomial distribution, it would be best to supply the \code{size} to the
\code{fix.arg} argument.

By default, the y values are such that the integral of the distribution is
1, which scales well with the defaults of kernel density estimates. When
comparing distributions with absolute count histograms, a sensible choice
for aesthetic mapping would be \code{aes(y = stat(count) * binwidth)},
wherein \code{binwidth} is matched with the bin width of the histogram.

For discrete distributions, the input data are expected to be integers, or
doubles that can be divided by 1 without remainders.

Parameters are estimated using the
\code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}} function in the
\pkg{fitdistrplus} package using maximum likelihood estimation.
Hypergeometric and multinomial distributions from the \pkg{stats} package
are not supported.
}
\section{Computed variables}{
 \describe{ \item{density}{probability density}
\item{count}{density * number of observations - useful for comparing to
histograms} \item{scaled}{density scaled to a maximum of 1} }
}

\examples{
# A mixture of normal distributions where the standard deviation is
# inverse gamma distributed resembles a cauchy distribution.
x <- rnorm(2000, 10, 1/rgamma(2000, 2, 0.5))
df <- data.frame(x = x)

ggplot(df, aes(x)) +
  geom_histogram(binwidth = 0.1,
                 alpha = 0.3, position = "identity") +
  stat_theodensity(aes(y = stat(count) * 0.1, colour = "Normal"),
                   distri = "norm", geom = "line") +
  stat_theodensity(aes(y = stat(count) * 0.1, colour = "Cauchy"),
                   distri = "cauchy", geom = "line") +
  coord_cartesian(xlim = c(5, 15))

# A negative binomial can be understood as a Poisson-gamma mixture
df <- data.frame(x = c(rpois(500, 25),
                       rpois(500, rgamma(500, 5, 0.2))),
                 cat = rep(c("Poisson", "Poisson-gamma"), each = 500))

ggplot(df, aes(x)) +
  geom_histogram(binwidth = 1, aes(fill = cat),
                 alpha = 0.3, position = "identity") +
  stat_theodensity(aes(y = stat(count), colour = cat), distri = "nbinom",
                   geom = "step", position = position_nudge(x = -0.5)) +
  stat_summary(aes(y = x, colour = cat, x = 1),
               fun.data = function(x){data.frame(xintercept = mean(x))},
               geom = "vline")
}
\seealso{
\code{\link[stats:Distributions]{stats::Distributions()}}
\code{\link[fitdistrplus:fitdist]{fitdistrplus::fitdist()}} \code{\link[ggplot2:geom_density]{ggplot2::geom_density()}}
\code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}}
}
