% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-auto.R, R/scale-pattern.R,
%   R/zxx.r
\name{scale_pattern_identity}
\alias{scale_pattern_identity}
\alias{scale_pattern_type_identity}
\alias{scale_pattern_subtype_identity}
\alias{scale_pattern_angle_identity}
\alias{scale_pattern_density_identity}
\alias{scale_pattern_spacing_identity}
\alias{scale_pattern_xoffset_identity}
\alias{scale_pattern_yoffset_identity}
\alias{scale_pattern_alpha_identity}
\alias{scale_pattern_linetype_identity}
\alias{scale_pattern_size_identity}
\alias{scale_pattern_shape_identity}
\alias{scale_pattern_colour_identity}
\alias{scale_pattern_fill_identity}
\alias{scale_pattern_fill2_identity}
\alias{scale_pattern_aspect_ratio_identity}
\alias{scale_pattern_key_scale_factor_identity}
\alias{scale_pattern_filename_identity}
\alias{scale_pattern_filter_identity}
\alias{scale_pattern_gravity_identity}
\alias{scale_pattern_scale_identity}
\alias{scale_pattern_orientation_identity}
\alias{scale_pattern_phase_identity}
\alias{scale_pattern_frequency_identity}
\alias{scale_pattern_grid_identity}
\alias{scale_pattern_res_identity}
\alias{scale_pattern_rot_identity}
\alias{scale_pattern_units_identity}
\alias{scale_pattern_color_identity}
\title{Use values without scaling}
\usage{
scale_pattern_type_identity(..., guide = "none")

scale_pattern_subtype_identity(..., guide = "none")

scale_pattern_angle_identity(..., guide = "none")

scale_pattern_density_identity(..., guide = "none")

scale_pattern_spacing_identity(..., guide = "none")

scale_pattern_xoffset_identity(..., guide = "none")

scale_pattern_yoffset_identity(..., guide = "none")

scale_pattern_alpha_identity(..., guide = "none")

scale_pattern_linetype_identity(..., guide = "none")

scale_pattern_size_identity(..., guide = "none")

scale_pattern_shape_identity(..., guide = "none")

scale_pattern_colour_identity(..., guide = "none")

scale_pattern_fill_identity(..., guide = "none")

scale_pattern_fill2_identity(..., guide = "none")

scale_pattern_aspect_ratio_identity(..., guide = "none")

scale_pattern_key_scale_factor_identity(..., guide = "none")

scale_pattern_filename_identity(..., guide = "none")

scale_pattern_filter_identity(..., guide = "none")

scale_pattern_gravity_identity(..., guide = "none")

scale_pattern_scale_identity(..., guide = "none")

scale_pattern_orientation_identity(..., guide = "none")

scale_pattern_phase_identity(..., guide = "none")

scale_pattern_frequency_identity(..., guide = "none")

scale_pattern_grid_identity(..., guide = "none")

scale_pattern_res_identity(..., guide = "none")

scale_pattern_rot_identity(..., guide = "none")

scale_pattern_units_identity(..., guide = "none")

scale_pattern_identity(..., guide = "none")
}
\arguments{
\item{..., guide}{See \code{ggplot2} for documentation on identity scales.
e.g. \code{ggplot2::scale_alpha_identity()}}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
Use values without scaling
}
\examples{
  if (require('ggplot2')) {
    df <- data.frame(outcome = c(2.3, 1.9, 3.2, 1),
                     pattern_type = sample(gridpattern::names_polygon_tiling, 4))
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(pattern_type, outcome, pattern_fill = pattern_type,
            pattern_type = pattern_type),
        colour  = 'black',
        pattern = 'polygon_tiling',
        pattern_key_scale_factor = 1.2
       ) +
       scale_pattern_type_identity() +
       theme_bw(18) +
       theme(legend.position = 'none') +
       labs(
         x        = 'level',
         title    = 'ggpattern::geom_col_pattern()',
         subtitle = 'pattern = \'polygon_tiling\''
       )
    plot(gg)
  }
}
