% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-pattern-viridis.R, R/zxx.r
\name{scale_pattern_colour_viridis_d}
\alias{scale_pattern_colour_viridis_d}
\alias{scale_pattern_fill_viridis_d}
\alias{scale_pattern_fill2_viridis_d}
\alias{scale_pattern_colour_viridis_c}
\alias{scale_pattern_fill_viridis_c}
\alias{scale_pattern_fill2_viridis_c}
\alias{scale_pattern_colour_ordinal}
\alias{scale_pattern_color_ordinal}
\alias{scale_pattern_fill_ordinal}
\alias{scale_pattern_fill2_ordinal}
\alias{scale_pattern_color_viridis_d}
\alias{scale_pattern_color_viridis_c}
\title{Viridis colour scales from viridisLite}
\usage{
scale_pattern_colour_viridis_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  aesthetics = "pattern_colour"
)

scale_pattern_fill_viridis_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_viridis_d(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  aesthetics = "pattern_fill2"
)

scale_pattern_colour_viridis_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_colour"),
  aesthetics = "pattern_colour"
)

scale_pattern_fill_viridis_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_fill"),
  aesthetics = "pattern_fill"
)

scale_pattern_fill2_viridis_c(
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  option = "D",
  values = NULL,
  space = "Lab",
  na.value = "grey50",
  guide = guide_colourbar(available_aes = "pattern_fill2"),
  aesthetics = "pattern_fill2"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}},
\code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}, or \code{\link[ggplot2:binned_scale]{ggplot2::binned_scale()}} to control name, limits, breaks,
labels and so forth.}

\item{begin, end, alpha, direction, option, values, space, na.value, guide}{See \code{\link[ggplot2:scale_viridis]{ggplot2::scale_colour_viridis_d()}} for more information}

\item{aesthetics}{Character string or vector of character strings listing the
name(s) of the aesthetic(s) that this scale works with. This can be useful, for
example, to apply colour settings to the \code{colour} and \code{fill} aesthetics at the
same time, via \code{aesthetics = c("colour", "fill")}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Scale} object.
}
\description{
The \code{viridis} scales provide colour maps that are perceptually uniform in both
colour and black-and-white. They are also designed to be perceived by viewers
with common forms of colour blindness. See also
\url{https://bids.github.io/colormap/}.
}
\examples{
  if (require("ggplot2")) {
    df <- data.frame(level = c("a", "b", "c", "d"),
                     outcome = c(2.3, 1.9, 3.2, 1))
    # discrete 'viridis' palette
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = level),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_viridis_d()
    plot(gg)

    # continuous 'viridis' palette
    gg <- ggplot(df) +
      geom_col_pattern(
        aes(level, outcome, pattern_fill = outcome),
        pattern = 'stripe',
        fill    = 'white',
        colour  = 'black'
      ) +
      theme_bw(18) +
      scale_pattern_fill_viridis_c()
    plot(gg)
  }
}
