% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/theme-defaults.r
\name{ggtheme}
\alias{ggtheme}
\alias{theme_bw}
\alias{theme_classic}
\alias{theme_gray}
\alias{theme_grey}
\alias{theme_light}
\alias{theme_linedraw}
\alias{theme_minimal}
\title{ggplot2 themes}
\usage{
theme_grey(base_size = 12, base_family = "")

theme_gray(base_size = 12, base_family = "")

theme_bw(base_size = 12, base_family = "")

theme_linedraw(base_size = 12, base_family = "")

theme_light(base_size = 12, base_family = "")

theme_minimal(base_size = 12, base_family = "")

theme_classic(base_size = 12, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Themes set the general aspect of the plot such as the colour of the
background, gridlines, the size and colour of fonts.
}
\details{
\describe{

\item{\code{theme_gray}}{
The signature ggplot2 theme with a grey background and white gridlines,
designed to put the data forward yet make comparisons easy.}

\item{\code{theme_bw}}{
The classic dark-on-light ggplot2 theme. May work better for presentations
displayed with a projector.}

\item{\code{theme_linedraw}}{
A theme with only black lines of various widths on white backgrounds,
reminiscent of a line drawings. Serves a purpose similar to \code{theme_bw}.
Note that this theme has some very thin lines (<< 1 pt) which some journals
may refuse.}

\item{\code{theme_light}}{
A theme similar to \code{theme_linedraw} but with light grey lines and axes,
to direct more attention towards the data.}

\item{\code{theme_minimal}}{
A minimalistic theme with no background annotations.}

\item{\code{theme_classic}}{
A classic-looking theme, with x and y axis lines and no gridlines.}

}
}
\examples{
p <- ggplot(mtcars) + geom_point(aes(x = wt, y = mpg,
     colour=factor(gear))) + facet_wrap(~am)

p
p + theme_gray()
p + theme_bw()
p + theme_linedraw()
p + theme_light()
p + theme_minimal()
p + theme_classic()
}

