% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ggrasp.write}
\alias{ggrasp.write}
\title{ggrasp.write}
\usage{
ggrasp.write(x, file, type, rank.level)
}
\arguments{
\item{x}{ggrasp-class object to be written}

\item{file}{String pointing to file where the data will be saved. If no file is given, the result will be printed out on the screen.}

\item{type}{Format of the data printed, either "tree" (New Hampshire extended style), "table" where the medoids or representative are shown in a table format, "list" where the information is shown in a pseudo-fasta format, or "itol" which prints out a file that can be loaded into the itol phylogeny viewer (http://itol.embl.de) which will color the clades of the different clusters}

\item{rank.level}{Maximum level of the rank to show. Ignored pre-clustering. After clustering, 0 will show only the medoids, -1 will show all values independent of rank, and any value >= 1 will show all the genomes less than or equal to that rank (including medoids). Default is 0 (only the medoids)}
}
\description{
writes formatted information from a class GGRaSP object to a file. Multiple output options are available.
}
\examples{
#Getting the ggrasp object
Enter.tree <- ggrasp.load(system.file("extdata", "Enter.kSNP.tree", package="ggrasp"), 
file.format = "tree", rank.file =system.file("extdata", "Enter.kSNP.ranks", package="ggrasp"));
\donttest{Enter.tree.cluster <- ggrasp.cluster(Enter.tree)}

#Default examples: using the initizalized ggrasp object will 
#write the newick tree string to "tree.nwk"
ggrasp.write(Enter.tree, type="tree", file=file.path(tempdir(), "tree.nwk"));

# Using the clustered ggrasp object will write a text file with the clusters saved as an ITOL clade
# In conjecture with the phylogeny, this is readable by 
# ITOL web phylogeny visualizer (http://itol.embl.de/) 
\donttest{ggrasp.write(Enter.tree.cluster, type="itol", file=file.path(tempdir(), "tree.itol.clade.txt"));}
}
