% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedcheck.R
\name{pedcheck}
\alias{pedcheck}
\title{Basic pedigree checks}
\usage{
pedcheck(ped)
}
\arguments{
\item{ped}{: \code{data.frame} with integer columns corresponding to ID, SIRE, DAM. Missing value is 0.}
}
\description{
Performs basic pedigree checks.
}
\examples{
set.seed(127)
ped = data.frame(ID=c(1:50,NA,0,1:3),
                 SIRE=c(0, sample(c(0,10:25), 53, replace=TRUE), 51),
                 DAM=c(0, NA, 52, sample(c(0,20:35), 52, replace=TRUE)))
pedcheck(ped)

}
