% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-uchicago.R
\name{scale_color_uchicago}
\alias{scale_color_uchicago}
\alias{scale_colour_uchicago}
\alias{scale_fill_uchicago}
\title{The University of Chicago color scales}
\usage{
scale_color_uchicago(palette = c("default", "light", "dark"), alpha = 1, ...)

scale_colour_uchicago(palette = c("default", "light", "dark"), alpha = 1, ...)

scale_fill_uchicago(palette = c("default", "light", "dark"), alpha = 1, ...)
}
\arguments{
\item{palette}{Palette type.
There are three available options:
\itemize{
\item \code{"default"} (9-color palette);
\item \code{"light"} (9-color light palette);
\item \code{"dark"} (9-color dark palette).
}}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}

\item{...}{Additional parameters for \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}
}
\description{
See \code{\link[=pal_uchicago]{pal_uchicago()}} for details.
}
\examples{
p1 <- example_scatterplot()
p2 <- example_barplot()

p1 + scale_color_uchicago()
p2 + scale_fill_uchicago()

p1 + scale_color_uchicago(palette = "light")
p2 + scale_fill_uchicago(palette = "light")

p1 + scale_color_uchicago(palette = "dark")
p2 + scale_fill_uchicago(palette = "dark")
}
\references{
\url{https://news.uchicago.edu/sites/default/files/attachments/_uchicago.identity.guidelines.pdf}
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
