% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-sidebar.r, R/geom-sidecol.r
\name{geom_xsidebar}
\alias{geom_xsidebar}
\alias{geom_*sidebar}
\alias{geom_ysidebar}
\alias{geom_xsidecol}
\alias{geom_ysidecol}
\title{Side bar Charts}
\usage{
geom_xsidebar(
  mapping = NULL,
  data = NULL,
  stat = "count",
  position = "stack",
  ...,
  width = NULL,
  na.rm = FALSE,
  orientation = "x",
  show.legend = NA,
  inherit.aes = TRUE
)

geom_ysidebar(
  mapping = NULL,
  data = NULL,
  stat = "count",
  position = "stack",
  ...,
  width = NULL,
  na.rm = FALSE,
  orientation = "y",
  show.legend = NA,
  inherit.aes = TRUE
)

geom_xsidecol(
  mapping = NULL,
  data = NULL,
  position = "stack",
  ...,
  width = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_ysidecol(
  mapping = NULL,
  data = NULL,
  position = "stack",
  ...,
  width = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  orientation = "y"
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Override the default connection between \code{geom_bar()} and
\code{stat_count()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{width}{Bar width. By default, set to 90\% of the resolution of the data.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
XLayer or YLayer object to be added to a ggplot object
}
\description{
The \link{xside} and \link{yside} variants of \link[ggplot2]{geom_bar} is
\link{geom_xsidebar} and \link{geom_ysidebar}. These variants both inherit
from \link[ggplot2]{geom_bar} and only differ on where they plot
data relative to main panels.

The \link{xside} and \link{yside} variants of \link[ggplot2]{geom_col} is
\link{geom_xsidecol} and \link{geom_ysidecol}. These variants both inherit
from \link[ggplot2]{geom_col} and only differ on where they plot
data relative to main panels.
}
\section{Aesthetics}{


Required aesthetics are in bold.

\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \emph{\code{fill} or \code{xfill}} Fill color of the xsidebar
\item \emph{\code{fill} or \code{yfill}} Fill color of the ysidebar
\item \emph{\code{width}} specifies the width of each bar
\item \emph{\code{height}} specifies the height of each bar
\item \emph{\code{alpha}} Transparency level of \code{xfill} or \code{yfill}
\item \emph{\code{size}} size of the border line.
}
}

\examples{

p <-ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species, fill = Species)) +
geom_point()

#sidebar - uses StatCount
p +
geom_xsidebar() +
geom_ysidebar()

#sidecol - uses Global mapping
p +
  geom_xsidecol() +
  geom_ysidecol()

}
\seealso{
\link{geom_xsidehistogram}, \link{geom_ysidehistogram}
}
