% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/101_geomandstat.R
\name{stat_sii_risksurface}
\alias{stat_sii_risksurface}
\title{stat_sii_risksurface}
\usage{
stat_sii_risksurface(mapping = NULL, data = NULL,
  geom = "sii_risksurface", position = "identity",
  show.legend = TRUE, inherit.aes = TRUE, na.rm = FALSE,
  levelmax = 99, structuredf = ggsolvencyii::sii_structure_sf16_eng,
  maxscrvalue = NULL, aggregatesuffix = "_other", scalingx = 1,
  scalingy = 1, rotationdegrees = NULL, rotationdescription = NULL,
  squared = FALSE, plotdetails = NULL, ...)
}
\arguments{
\item{mapping}{required aes(thetics) : x (i.e. time, longitude), y (i.e SCR ratio, lattitude), id, description (), value}

\item{data}{the dataset in tidyverse format (column 'description' as a factor). see examples in \code{\link{sii_z_ex2_data}} or \code{\link{sii_z_ex3_data}}}

\item{geom}{the default is geom_sii_risksurface}

\item{position}{standard ggplot function}

\item{show.legend}{standard ggplot function}

\item{inherit.aes}{standard ggplot function}

\item{na.rm}{standard ggplot function}

\item{levelmax}{(integer or dataframe, default = 99)\cr a positive integer or a dataframe with columns 'level' and 'levelmax'. \cr The maximum amount of items in a certain level to be plotted. The smallest items are combined to one item. In the case level consisting of 7 items has a levelmax of 5 this results in 4 separate items and one grouped item. \cr
For a less detailed plot \code{\link{sii_levelmax_sf16_995}} and \code{\link{sii_levelmax_sf16_993}} are present in the package where the components of market, life, non-life, health are combined in 5 or 3 items.}

\item{structuredf}{(dataframe: default = \code{\link{sii_structure_sf16_eng}})\cr A representation of the buildup from individual risks to the SCR. columns are \enumerate{\item description (chr),\item  level (chr),\item  childlevel (chr)}. In the standard formula structure, SCR has level 1, with childlevel 2. This means it consists of all datalines with level == 2, ie. "BSCR", "operational" and "Adjustment-LACDT". lines in the dataset with a suffix "d" behind the levelnumber are diversification items. As of now these are not used in any calculation. the values in column "description" in the dataset need to match the description in this file. The package contains also a file \code{\link{sii_structure_sf16_nld}} with Dutch terms in description column.}

\item{maxscrvalue}{(optional, double, default = NULL)\cr
the scale of the different plot elements is is by default measured to the largest level 1 element (i.e. SCR) in the dataset, this can be overridden by this parameter for example when combining several plots}

\item{aggregatesuffix}{(string, default = "_other")\cr When a certain level contains more items than specified by levelmax  the smallest items are combined. The description is of the name of the one higher level (lower number) with a suffix}

\item{scalingx}{(optional, positive value ,default = 1)\cr for plots where units in x and y are different in magnitude distortion can occur. This parameter scales only in x-direction}

\item{scalingy}{(optional, positive value ,default = 1)\cr for plots where units in x and y are different in magnitude distortion can occur. This parameter scales only in y-direction}

\item{rotationdegrees}{(optional, integer, -360 to 360, default = NULL)\cr when given, the fixed amount of degrees (positive is clockwise) of which each item is rotated (as in a compass, -90 is a quarter rotation anti-clockwise), additive to possible rotation to description}

\item{rotationdescription}{(optional, string, default = NULL)\cr default the orientation of the lower level (higher number) circles is based on the structure. When this parameter is not NULL then the circles are rotated in such a way that the indicated item lies in the "north-east" part of the circle.}

\item{squared}{(optional, boolean, default = FALSE)\cr when set to TRUE plot returns a square representation. Compared with a circle representation of the same data the height and width of the square are smaller than the radius of the circle. Segments which fall in the corner parts of the square are smaller than equally sized part which fall in the vertical or horizontal parts of the square.}

\item{plotdetails}{a table with columns 'levelordescription' and 'surface', indicating which circle elements to plot. When no table is provided all segments are plotted. example 3 shows how to combine geom_sii_risksurface and geom_sii_riskoutline by using using table \code{\link{sii_z_ex3_plotdetails}}. geom_sii_riskoutline uses other columns in the same table}

\item{...}{ellipsis, a standard R parameter}
}
\value{
a ggplot object
}
\description{
returns a 'ggplot2' object with filled, concentric circle(part)s, defined by the values of a hierarchy of levels.
}
