% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-north-arrow.R
\docType{data}
\name{annotation_north_arrow}
\alias{annotation_north_arrow}
\alias{GeomNorthArrow}
\title{Spatial-aware north arrow}
\format{An object of class \code{GeomNorthArrow} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 4.}
\usage{
annotation_north_arrow(height = unit(1.5, "cm"), width = unit(1.5, "cm"),
  pad_x = unit(0.25, "cm"), pad_y = unit(0.25, "cm"),
  which_north = c("grid", "true"), rotation = NULL, location = c("tr",
  "bl", "br", "tl"), style = north_arrow_orienteering)

GeomNorthArrow
}
\arguments{
\item{height, width}{Height and width of north arrow}

\item{pad_x, pad_y}{Padding between north arrow and edge of frame}

\item{which_north}{"grid" results in a north arrow always pointing up; "true" always points to the
north pole from whichever corner of the map the north arrow is in.}

\item{rotation}{Override the rotation of the north arrow (degrees conterclockwise)}

\item{location}{Where to put the north arrow ("tl" for top left, etc.)}

\item{style}{A grob or callable that produces a grob that will be drawn as the north arrow.
See \link{north_arrow_orienteering} for options.}
}
\value{
A ggplot2 layer
}
\description{
Spatial-aware north arrow
}
\examples{

cities <- data.frame(
  x = c(-63.58595, 116.41214),
  y = c(44.64862, 40.19063),
  city = c("Halifax", "Beijing")
)

ggplot(cities) +
  geom_spatial_point(aes(x, y), crs = 4326) +
  annotation_north_arrow(which_north = "true") +
  coord_sf(crs = 3995)

ggplot(cities) +
  geom_spatial_point(aes(x, y), crs = 4326) +
  annotation_north_arrow(which_north = "grid") +
  coord_sf(crs = 3995)

}
\keyword{datasets}
