% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-mean.R
\name{stat_wb_mean}
\alias{stat_wb_mean}
\title{Integrate ranges under curve.}
\usage{
stat_wb_mean(mapping = NULL, data = NULL, geom = "rect", w.band = NULL,
  integral.fun = photobiology::integrate_xy, label.mult = 1,
  label.fmt = "\%.3g", ypos.mult = 0.55, ypos.fixed = NULL,
  position = "identity", na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{integral.fun}{function on $x$ and $y$.}

\item{label.mult}{numeric Scaling factor applied to y-integral values before
conversion into character strings.}

\item{label.fmt}{character string giving a format definition for converting
y-integral values into character strings by means of function
\code{\link{sprintf}}.}

\item{ypos.mult}{numeric Multiplier constant used to scale returned
\code{y} values.}

\item{ypos.fixed}{numeric If not \code{NULL} used a constant value returned
in \code{y}.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_wb_mean} computes means under a curve. It first integrates the
  area under a spectral curve and also the mean expressed per nanaometre of
  wavelength for each waveband in the input. Sets suitable default aestheics
  for "rect", "hline", "vline", "text" and "label" geoms.
}
\section{Computed variables}{

\describe{
  \item{label}{intergral value as formatted text}
  \item{x}{w.band-midpoint}
  \item{xmin}{w.band minimum}
  \item{xmax}{w.band maximum}
  \item{ymean}{Mean value as numeric}
  \item{yint}{Integral value as numeric}
}
}
\examples{
library(photobiology)
library(photobiologyWavebands)
library(ggplot2)
# ggplot() methods for spectral objects set a default mapping for x and y.
ggplot(sun.spct) +
  stat_wb_mean(w.band = VIS_bands()) +
  stat_wb_mean(w.band = VIS_bands(),
               geom = "text", angle = 90, size = 2.5,
               label.fmt = "\%1.2f") +
  geom_line() +
  scale_fill_identity()

}
\seealso{
Other stats functions: \code{\link{stat_color}},
  \code{\link{stat_peaks}},
  \code{\link{stat_wb_contribution}},
  \code{\link{stat_wb_irrad}}, \code{\link{stat_wb_label}},
  \code{\link{stat_wb_relative}},
  \code{\link{stat_wb_sirrad}},
  \code{\link{stat_wb_total}}, \code{\link{stat_wl_strip}},
  \code{\link{stat_wl_summary}}
}

