% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-wb-mean.R
\name{stat_wb_mean}
\alias{stat_wb_mean}
\title{Integrate ranges under curve.}
\usage{
stat_wb_mean(
  mapping = NULL,
  data = NULL,
  geom = "text",
  position = "identity",
  ...,
  w.band = NULL,
  integral.fun = integrate_xy,
  label.mult = 1,
  chroma.type = "CMF",
  label.fmt = "\%.3g",
  ypos.mult = 1.07,
  xpos.fixed = NULL,
  ypos.fixed = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{w.band}{a waveband object or a list of waveband objects or numeric
vector of at least length two.}

\item{integral.fun}{function on $x$ and $y$.}

\item{label.mult}{numeric Scaling factor applied to y-integral values before
conversion into character strings.}

\item{chroma.type}{character one of "CMF" (color matching function) or "CC"
(color coordinates) or a \code{\link[photobiology]{chroma_spct}} object.}

\item{label.fmt}{character string giving a format definition for converting
y-integral values into character strings by means of function
\code{\link{sprintf}}.}

\item{ypos.mult}{numeric Multiplier constant used to scale returned
\code{y} values.}

\item{xpos.fixed, ypos.fixed}{numeric If not \code{NULL} used as constant value returned
in \code{x} or \code{y}.}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A data frame with one row for each waveband object in the argument
to \code{w.band}. Wavebeand outside the range of the spectral data are
trimmed or discarded.
}
\description{
\code{stat_wb_mean} computes mean spectral irradiance under a curve for each
waveband in the input. Sets suitable default aesthetics for "rect", "hline",
"vline", "text" and "label" geoms. \strong{\code{x}-scale transformations
and axis flipping are currently not supported}.
}
\section{Computed variables}{

What it is named integral below is the result of appying \code{integral.fun},
with default \code{integrate_xy}.
\describe{
  \item{y.label}{ymean multiplied by \code{label.mult} and formatted
  according to \code{label.fmt}}
  \item{x}{w.band-midpoint}
  \item{wb.xmin}{w.band minimum}
  \item{wb.xmax}{w.band maximum}
  \item{wb.ymin}{data$y minimum}
  \item{wb.ymax}{data$y maximum}
  \item{wb.yint}{data$y integral for the range of \code{w.band}}
  \item{wb.xmean}{yint divided by wl_expanse(w.band)}
  \item{y}{ypos.fixed or top of data, adjusted by \code{ypos.mult}}
  \item{wb.color}{color of the w.band}
  \item{wb.name}{label of w.band}
  \item{BW.color}{\code{black_or_white(wb.color)}}
}
}

\section{Default aesthetics}{

Set by the statistic and available to geoms.
\describe{
  \item{label}{..y.label..}
  \item{x}{..x..}
  \item{xmin}{..wb.xmin..}
  \item{xmax}{..wb.xmax..}
  \item{ymin}{0}
  \item{ymax}{..wb.ymean..}
  \item{yintercept}{..wb.ymean..}
  \item{fill}{..wb.color..}
}
}

\section{Required aesthetics}{

Required by the statistic and need to be set with \code{aes()}.
\describe{
  \item{x}{numeric, wavelength in nanometres}
  \item{y}{numeric, a spectral quantity}
}
}

\examples{

library(photobiologyWavebands)
# ggplot() methods for spectral objects set a default mapping for x and y.

# Using defaults
ggplot(sun.spct) +
  stat_wb_column(w.band = VIS_bands()) +
  stat_wb_mean(w.band = VIS_bands(),
               color = "black") +
  scale_fill_identity() + scale_color_identity()

# Setting format for numbers, position, angle, and color
ggplot(sun.spct) +
  stat_wb_column(w.band = VIS_bands(), alpha = 0.5) +
  stat_wb_mean(w.band = VIS_bands(),
               label.fmt = "\%.2f",
               angle = 90, color = "black", ypos.fixed = 0.1) +
  geom_line() +
  scale_fill_identity() + scale_color_identity() +
  theme_bw()

# Changing label mapping
ggplot(sun.spct) +
  stat_wb_column(w.band = VIS_bands(), alpha = 0.5) +
  stat_wb_mean(w.band = VIS_bands(),
               label.fmt = "\%.2f",
               angle = 90, color = "black", ypos.fixed = 0.1,
               hjust = "left", size = 3,
               mapping = aes(label = after_stat(paste(wb.name, ": ", y.label, sep = "")))) +
  geom_line() +
  scale_fill_identity() + scale_color_identity() +
  theme_bw()

# example using repulsion
library(ggrepel)
ggplot(sun.spct) +
  geom_line() +
  stat_wb_hbar(w.band = VIS_bands(), size = 1.5) +
  stat_wb_mean(w.band = VIS_bands(),
               geom = "label_repel", nudge_y = +0.04, size = 3,
               segment.colour = NA, label.size = NA) +
  expand_limits(y = 0.9) +
  scale_fill_identity() + scale_color_identity() +
  theme_bw()

}
\seealso{
Other stats functions: 
\code{\link{stat_color}()},
\code{\link{stat_find_qtys}()},
\code{\link{stat_find_wls}()},
\code{\link{stat_label_peaks}()},
\code{\link{stat_peaks}()},
\code{\link{stat_spikes}()},
\code{\link{stat_wb_box}()},
\code{\link{stat_wb_column}()},
\code{\link{stat_wb_contribution}()},
\code{\link{stat_wb_hbar}()},
\code{\link{stat_wb_irrad}()},
\code{\link{stat_wb_label}()},
\code{\link{stat_wb_relative}()},
\code{\link{stat_wb_sirrad}()},
\code{\link{stat_wb_total}()},
\code{\link{stat_wl_strip}()},
\code{\link{stat_wl_summary}()}
}
\concept{stats functions}
