% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-binh.R
\name{stat_binh}
\alias{stat_binh}
\title{Horizontal binning.}
\usage{
stat_binh(mapping = NULL, data = NULL, geom = "barh",
  position = "stackv", ..., binwidth = NULL, bins = NULL, center = NULL,
  boundary = NULL, closed = c("right", "left"), pad = FALSE,
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{geom}{Use to override the default connection between
\code{geom_histogram}/\code{geom_freqpoly} and \code{stat_bin}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{binwidth}{The width of the bins. The default is to use \code{bins}
  bins that cover the range of the data. You should always override
  this value, exploring multiple widths to find the best to illustrate the
  stories in your data.

  The bin width of a date variable is the number of days in each time; the
  bin width of a time variable is the number of seconds.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30}

\item{center}{The center of one of the bins.  Note that if center is above or
below the range of the data, things will be shifted by an appropriate
number of \code{width}s. To center on integers, for example, use
\code{width = 1} and \code{center = 0}, even if \code{0} is outside the range
of the data.  At most one of \code{center} and \code{boundary} may be
specified.}

\item{boundary}{A boundary between two bins. As with \code{center}, things
are shifted when \code{boundary} is outside the range of the data. For
example, to center on integers, use \code{width = 1} and \code{boundary =
0.5}, even if \code{0.5} is outside the range of the data.  At most one of
\code{center} and \code{boundary} may be specified.}

\item{closed}{One of \code{"right"} or \code{"left"} indicating whether right
or left edges of bins are included in the bin.}

\item{pad}{If \code{TRUE}, adds empty bins at either end of x. This ensures
frequency polygons touch 0. Defaults to \code{FALSE}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
Horizontal version of \code{\link[ggplot2]{stat_bin}}().
}

