% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{zzz-internal}
\alias{arrow_label_formatter}
\alias{find_global_tern}
\alias{getBreaks}
\alias{getFormulaVars}
\alias{identityInv}
\alias{ifthenelse}
\alias{is.numericor}
\alias{joinCharacterSeries}
\alias{scales_add_missing_tern}
\alias{tern_dep}
\alias{zzz-internal}
\title{Internal Functions}
\usage{
ifthenelse(x, a, b)

is.numericor(A, B)

find_global_tern(name, env = environment())

getBreaks(limits, isMajor, nMajor = 5, nMinor = 2 * nMajor)

tern_dep(version, msg)

arrow_label_formatter(label, suffix = NULL, sep = "/")

joinCharacterSeries(x, lastWord = "and")

identityInv(z)

getFormulaVars(x, dependent = TRUE)

scales_add_missing_tern(plot)
}
\arguments{
\item{x}{logical input to check}

\item{a}{value to return if \code{x} is TRUE}

\item{b}{value to return if \code{x} is FALSE}

\item{A}{value to return if numeric}

\item{B}{numeric value to return if \code{A} is NOT numeric}

\item{name}{character name of object to search for}

\item{env}{environment to search within as first priority}

\item{limits}{the scale limits}

\item{isMajor}{major or minor grids}

\item{nMajor}{number of major breaks}

\item{nMinor}{number of minor breaks}

\item{version}{The last version of ggplot2 where this function was good
(in other words, the last version where it was not deprecated).}

\item{msg}{The message to print.}

\item{label}{character label}

\item{suffix}{chacater suffix behind each label}

\item{sep}{the seperator between label and suffix}

\item{dependent}{whether to return the dependent variables (TRUE) or the indpenedent variables (FALSE)}

\item{plot}{object}

\item{x}{character vector}

\item{x}{input object}

\item{x}{formula object}
}
\description{
INTERNAL FUNCTIONS: \code{ggtern} makes use of several non-exported internal functions, list are as follows:

\code{ifthenelse} function takes input arguments \code{x}, \code{a} and \code{b} and returns \code{a} if \code{x} is \code{TRUE}, else, returns \code{b}

\code{is.numericor} function takes input arguments \code{A} and \code{B} and returns \code{A} if \code{A} is numeric, else, returns \code{B}

\code{find_global_tern} is a function that conducts a named search for the \code{name} object instance, within the \code{env} environment. 
If an instance doesn't exist within the \code{env} environment, a search is then conducted within the \code{ggtern} and \code{ggplot2} 
namespaces \emph{(in that order)}. This is a modified version of the original source as provided in \code{ggplot2}, which has the same functionality, however, the modification is such that the function
now additionally searches within the \code{ggtern} namespace prior to the \code{ggplot2} namespace.

\code{getBreaks} is a function that calculates the Breaks for Major or Minor Gridlines based 
on the input limits.

\code{tern_dep} is a function that gives a deprecation error, warning, or messsage, 
depending on version number, it is based of the \code{\link[ggplot2]{gg_dep}} function which is
used inside the \code{ggplot2} package

\code{arrow_label_formatter} is a function that formats the labels directly adjacent to the ternary arrows.

\code{joinCharacterSeries} is a function will turn a character vector 
from the format \code{c('a','b','c')} to a single string
in the following format: \code{"'a','b' and 'c'"}

\code{identityInv} is a function which returns exactly the same as \code{\link{identity}} however
it can be used within transformation logic via \code{do.call(...)} in the same way as for example
\code{\link{ilrInv}} is to \code{\link{ilr}}.

\code{getFormulaVars} is a function that returns a list of either dependent or independent variables used
in an input formula

Function to add missing scales and other items to the plot and its coordinates sytem
}
\author{
Nicholas Hamilton

Nicholas Hamilton

Nicholas Hamilton

Nicholas Hamilton
}
\keyword{internal}

