% Generated by roxygen2 (4.0.2): do not edit by hand
\name{theme_hc}
\alias{theme_hc}
\title{Highcharts JS theme}
\usage{
theme_hc(base_size = 12, base_family = "sans", bgcolor = "default")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}

\item{bgcolor}{The background color of plot. One of \code{"default",
"darkunica"}, the names of values in
\code{ggthemes_data$hc$bg}.}
}
\description{
Theme based on the plots in \emph{Highcharts JS}.
}
\examples{
(qplot(hp, mpg, data = mtcars, geom = "point")
+ scale_colour_hc()
+ ggtitle("Diamond Prices")
+ theme_hc())
## Use a Dark-Unica theme
(qplot(hp, mpg, data = mtcars, geom = "point")
+ scale_colour_hc("darkunica")
+ ggtitle("Diamond Prices")
+ theme_hc(bgcolor = "darkunica"))
}
\references{
\url{http://www.highcharts.com/demo/line-basic}

\url{https://github.com/highslide-software/highcharts.com/tree/master/js/themes}
}

