% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtikzAnnotation.R
\name{ggtikzAnnotation}
\alias{ggtikzAnnotation}
\title{Prepare a TikZ annotation for a ggplot.}
\usage{
ggtikzAnnotation(
  tikz_code,
  x = c("data", "panel"),
  y = c("data", "panel"),
  xy = NULL,
  panelx = NULL,
  panely = NULL,
  clip = "inherit"
)
}
\arguments{
\item{tikz_code}{The tikz code to use for annotation. Backslashes must be escaped!}

\item{x}{Reference frame for the x coordinates. Either "data" or "panel".}

\item{y}{Reference frame for the y coordinates. Either "data" or "panel".}

\item{xy}{Reference frame for both x and y coordinates. Trumps \code{x} and \code{y}. Either "data" or "panel" or "plot".}

\item{panelx}{x position of the panel to use as coordinate reference, starting from the left, 1-based.}

\item{panely}{y position of the panel to use as coordinate reference, starting from the top, 1-based.}

\item{clip}{Should annotations be clipped to the panel boundaries?
See the \code{clip} argument to \code{\link[grid]{viewport}}}
}
\value{
A ggtikzAnnotation object, which can be added to a ggtikzCanvas object.
}
\description{
ggtikzAnnotation objects are meant to be added to a ggtikzCanvas object.
}
\details{
This function prepares TikZ annotations in a form understandable to a
ggtikzCanvas object.
An annotation can be added to multiple ggtikzCanvas objects, provided that each
underlying ggplot object has the necessary panels to know what to do with this
information.
}
\seealso{
\code{\link[tikzDevice]{grid.tikzAnnotate}} for annotation of base graphics

\code{\link{ggtikz}} for a helper function for quick one-step annotations.

\code{\link{ggtikzCanvas}} for information about initiating the annotation process.
}
