% Generated by roxygen2 (4.0.1): do not edit by hand
\name{handle_brush}
\alias{handle_brush}
\title{Handle brush events on a visualisation.}
\usage{
handle_brush(vis, on_move = NULL, fill = "black")
}
\arguments{
\item{vis}{Visualisation to listen to.}

\item{on_move}{Callback function with arguments:
\describe{
 \item{items}{A data frame containing information about the items
   under the plot. An empty data.frame if no points under the brush.}
 \item{page_loc}{Location of the brush with repsect to the page}
 \item{plot_loc}{Location of the brush with respect to the plot}
 \item{session}{The session, used to communicate with the browser}
}}

\item{fill}{Colour of the brush.}
}
\description{
Currently for brush events to be triggered on a visualisation, you must
use a \code{.brush} property. This limitation will be lifted in the future.
}
\examples{
# Display tooltip when objects are brushed
mtcars \%>\%
  ggvis(x = ~wt, y = ~mpg, size.brush := 400) \%>\%
  layer_points() \%>\%
  handle_brush(function(items, page_loc, session, ...) {
    show_tooltip(session, page_loc$r + 5, page_loc$t, html = nrow(items))
  })
}

