% Generated by roxygen2 (4.0.1): do not edit by hand
\name{zero_range}
\alias{zero_range}
\title{Determine if range of vector is close to zero, with a specified tolerance}
\usage{
zero_range(x, tol = .Machine$double.eps * 100)
}
\arguments{
\item{x}{numeric range: vector of length 2}

\item{tol}{A value specifying the tolerance. Defaults to
\code{.Machine$double.eps * 100}.}
}
\value{
logical \code{TRUE} if the relative difference of the endpoints of
the range are not distinguishable from 0.
}
\description{
The machine epsilon is the difference between 1.0 and the next number
that can be represented by the machine. By default, this function
uses epsilon * 100 as the tolerance. First it scales the values so that
they have a mean of 1, and then it checks if the difference between
them is larger than the tolerance.
}
\examples{
eps <- .Machine$double.eps
zero_range(c(1, 1 + eps))       # TRUE
zero_range(c(1, 1 + 99 * eps))  # TRUE
zero_range(c(1, 1 + 101 * eps)) # FALSE - Crossed the tol threshold
zero_range(c(1, 1 + 2 * eps), tol = eps) # FALSE - Changed tol

# Scaling up or down all the values has no effect since the values
# are rescaled to 1 before checking against tol
zero_range(100000 * c(1, 1 + eps))        # TRUE
zero_range(100000 * c(1, 1 + 200 * eps))  # FALSE
zero_range(.00001 * c(1, 1 + eps))        # TRUE
zero_range(.00001 * c(1, 1 + 200 * eps))  # FALSE

# NA values
zero_range(c(1, NA))   # NA
zero_range(c(1, NaN))  # NA

# Infinite values
zero_range(c(1, Inf))     # FALSE
zero_range(c(-Inf, Inf))  # FALSE
zero_range(c(Inf, Inf))   # TRUE
}

