% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shiny.R, R/shiny_layout.R
\name{shiny-ggvis}
\alias{bind_shiny}
\alias{bind_shiny_ui}
\alias{ggvisOutput}
\alias{shiny-ggvis}
\title{Connect a ggvis graphic to a shiny app.}
\usage{
bind_shiny(vis, plot_id, controls_id = NULL, ...,
  session = shiny::getDefaultReactiveDomain())

bind_shiny_ui(vis, controls_id, session = shiny::getDefaultReactiveDomain())

ggvisOutput(plot_id = rand_id("plot_id"))
}
\arguments{
\item{vis}{A ggvis object, or a reactive expression that returns a ggvis
object.}

\item{plot_id}{unique identifier to use for the div containing the ggvis plot.}

\item{controls_id}{Unique identifier for controls div.}

\item{...}{Other arguments passed to \code{as.vega}.}

\item{session}{A Shiny session object.}
}
\description{
Embedding ggvis in a shiny app is easy. You need to make a place for it in
your \code{ui.r} with \code{ggvisOutput}, and tell your \code{server.r}
where to draw it with \code{bind_shiny}. It's easiest to learn by example:
there are many shiny apps in \code{demo/apps/} that you can learn from.
}
\section{Client-side}{

In your UI, use \code{ggvisOutput()} in \code{ui.r} to insert an html
placeholder for the plot.

If you're going to be using interactive controls generated by ggvis,
use \code{\link[shiny]{renderUI}()} to add a place holder. By convention,
if the id of plot placehold is called "plot", call the controls placeholder
"plot_ui".
}

\section{Server-side}{

When you run ggvis plot interactively, it is automatically plotted because
it triggers the default print method. In shiny apps, you need to
explicitly render the plot to a specific placeholder with
\code{bind_shiny}:

\code{p \%>\% bind_shiny("plot")}

If the plot has controls, and you've reserved space for them in the UI,
supply the name of the placeholder as the third argument:

\code{p \%>\% bind_shiny("plot", "plot_ui")}
}
\examples{
## Run these examples only in interactive R sessions
if (interactive()) {

# Simplest possible app:
library(shiny)
runApp(list(
  ui = bootstrapPage(
    ggvisOutput("p"),
    uiOutput("p_ui")
  ),
  server = function(..., session) {
    mtcars \%>\%
      ggvis(~wt, ~mpg) \%>\%
      layer_points() \%>\%
      layer_smooths(span = input_slider(0, 1)) \%>\%
      bind_shiny("p", "p_ui")
  }
))

}
}

