% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{is_empty}
\alias{is_empty}
\alias{is_empty,git_repository-method}
\alias{is_empty,missing-method}
\title{Check if repository is empty}
\usage{
is_empty(repo)

\S4method{is_empty}{missing}()

\S4method{is_empty}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository to check if it's empty}
}
\value{
TRUE if empty else FALSE
}
\description{
Check if repository is empty
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Check if it's an empty repository
is_empty(repo)

## Commit a file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Check if it's an empty repository
is_empty(repo)
}
}
\keyword{methods}

