% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{show,git_repository-method}
\alias{show,git_repository-method}
\alias{show,git_repository-methods}
\title{Brief summary of repository}
\usage{
\S4method{show}{git_repository}(object)
}
\arguments{
\item{object}{The repository \code{object}}
}
\value{
None (invisible 'NULL').
}
\description{
Brief summary of repository
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Brief summary of the repository
repo

## Create and commit a file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit(repo, "First commit message")

## Brief summary of the repository
repo
}
}
\keyword{methods}

