% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sha.R
\name{sha}
\alias{sha}
\alias{sha.git_blob}
\alias{sha.git_branch}
\alias{sha.git_commit}
\alias{sha.git_note}
\alias{sha.git_reflog_entry}
\alias{sha.git_tag}
\alias{sha.git_tree}
\alias{sha.git_fetch_head}
\alias{sha.git_merge_result}
\title{Get the SHA-1 of a git object}
\usage{
sha(object)

\method{sha}{git_blob}(object)

\method{sha}{git_branch}(object)

\method{sha}{git_commit}(object)

\method{sha}{git_note}(object)

\method{sha}{git_reflog_entry}(object)

\method{sha}{git_tag}(object)

\method{sha}{git_tree}(object)

\method{sha}{git_fetch_head}(object)

\method{sha}{git_merge_result}(object)
}
\arguments{
\item{object}{a git object to get the SHA-1 from.}
}
\value{
The 40 character hexadecimal string of the SHA-1.
}
\description{
Get the 40 character hexadecimal string of the SHA-1.
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Commit message 1")

## Get the SHA-1 of the last commit
sha(last_commit(repo))
}
}
