% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upgrade_data.R
\name{upgrade_data}
\alias{upgrade_data}
\alias{upgrade_data.git_repository}
\title{Upgrade Files to the New Version}
\usage{
upgrade_data(file, root = ".", verbose, ..., path)

\method{upgrade_data}{git_repository}(
  file,
  root = ".",
  verbose = TRUE,
  ...,
  path,
  stage = FALSE,
  force = FALSE
)
}
\arguments{
\item{file}{the name of the git2rdata object. Git2rdata objects cannot
have dots in their name. The name may include a relative path. \code{file} is a
path relative to the \code{root}.
Note that \code{file} must point to a location within \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (\code{"."}).}

\item{verbose}{display a message with the update status. Defaults to \code{TRUE}.}

\item{...}{parameters used in some methods}

\item{path}{specify \code{path} instead of \code{file} to update all git2rdata objects
in this directory and it's subdirectories. \code{path} is relative to \code{root}. Use
\code{path = "."} to upgrade all git2rdata objects under \code{root}.}

\item{stage}{Logical value indicating whether to stage the changes after
writing the data. Defaults to \code{FALSE}.}

\item{force}{Add ignored files. Default is FALSE.}
}
\value{
the git2rdata object names.
}
\description{
Updates the data written by older versions to the current data format
standard. Works both on a single file and (recursively) on a path. The
\code{".yml"} file must contain a \code{"..generic"} element. \code{upgrade_data()} ignores
all other files.
}
\examples{
# create a directory
root <- tempfile("git2rdata-")
dir.create(root)

# write dataframes to the root
write_vc(
  iris[1:6, ], file = "iris", root = root, sorting = "Sepal.Length",
  digits = 6
)
write_vc(
  iris[5:10, ], file = "subdir/iris", root = root, sorting = "Sepal.Length",
  digits = 6
)
# upgrade a single git2rdata object
upgrade_data(file = "iris", root = root)
# use path = "." to upgrade all git2rdata objects under root
upgrade_data(path = ".", root = root)
}
\seealso{
Other internal: 
\code{\link{is_git2rdata}()},
\code{\link{is_git2rmeta}()},
\code{\link{meta}()},
\code{\link{print.git2rdata}()},
\code{\link{summary.git2rdata}()}
}
\concept{internal}
