% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gi_fetch_templates.R
\name{gi_fetch_templates}
\alias{gi_fetch_templates}
\title{Fetch gitignore template(s) from gitignore.io}
\usage{
gi_fetch_templates(template_name, copy_to_clipboard = FALSE,
  append_gitignore = FALSE, gitignore_file = here::here(".gitignore"))
}
\arguments{
\item{template_name}{A character vector with values included in
\code{\link{gi_available_templates}}.}

\item{copy_to_clipboard}{Logical. Should the returned template(s) be copied
to the clipboard? Otherwise, it will be printed in the console. Default is FALSE.}

\item{append_gitignore}{Logical. Should the .gitignore be modified to include
the returned template(s)?}

\item{gitignore_file}{The path of the .gitignore file to be modified. By
default, it will try to find it in the current package/project using
`here::here(".gitignore")`.}
}
\value{
A character containing gitignore template(s).
}
\description{
Fetch gitignore template(s) from gitignore.io
}
\examples{
# Fetch template for the R language
gi_fetch_templates("R")

# You can combine many templates at once
gi_fetch_templates(c("R", "python", "java"))

# The .gitignore file can be automatically modified with `append_gitignore = TRUE`
gi_fetch_templates(c("R", "python", "java"))
}
