% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/issues.R
\name{gl_list_issues}
\alias{gl_list_issues}
\alias{gl_get_issue}
\title{Get issues of a project or user}
\usage{
gl_list_issues(project = NULL, issue_id = NULL, verb = httr::GET,
  force_api_v3 = FALSE, ...)

gl_get_issue(issue_id, project, ...)
}
\arguments{
\item{project}{project name or id, may be null for all issues created by user}

\item{issue_id}{optional issue id (projectwide; for API v3 only you can use global iid when force_api_v3 is `TRUE`)}

\item{verb}{ignored; all calls with this function will have \code{\link{gitlab}}'s
default verb \code{httr::GET}}

\item{force_api_v3}{a switch to force deprecated gitlab API v3 behavior that allows filtering by global iid. If `TRUE`
filtering happens by global iid, if false, it happens by projectwide ID. For API v4, this must be FALSE (default)}

\item{...}{further parameters passed on to \code{\link{gitlab}}, may be
state, labels, issue id, ...}
}
\description{
Get issues of a project or user
}
\details{
\code{gl_get_issue} provides a wrapper with swapped arguments for convenience, esp. when
using a project connection
}
\examples{
\dontrun{
my_project <- gl_project_connection(project = "testor"...) ## fill in login parameters
my_project(gl_list_issues)
my_project(gl_get_issue, 1)
my_project(gl_new_issue, 1, "Implement new feature", description = "It should be awesome.")
}
}
