% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glassdoor_employer.R
\name{gd_company}
\alias{gd_company}
\alias{gd_employer}
\title{Glassdoor Company Search}
\usage{
gd_company(..., location = NULL, city = NULL, state = NULL,
  country = NULL, page_number = NULL, page_size = NULL, query = NULL)

gd_employer(..., location = NULL, city = NULL, state = NULL,
  country = NULL, page_number = NULL, page_size = NULL, query = NULL)
}
\arguments{
\item{...}{arguments to pass to \code{\link{gd_api}}}

\item{location}{Scope the search to a specific location by specifying it
here - city, state, or country.}

\item{city}{Scope the search to a specific city by specifying it here.}

\item{state}{Scope the search to a specific state by specifying it here.}

\item{country}{Scope the search to a specific country by specifying it here.}

\item{page_number}{Page number to retrieve. Default is 1.}

\item{page_size}{Page size, i.e. the number of jobs returned on
each page of results. Default is 20.}

\item{query}{Additional options to pass to the query other than those
specified here}
}
\description{
Glassdoor Company Search
}
\examples{
if (have_gd_tokens()) {

paste0("action=employers")
res = gd_company()
}

}
