% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefplot.gllvm.R
\name{coefplot.gllvm}
\alias{coefplot.gllvm}
\alias{coefplot}
\title{Plot covariate coefficients and confidence intervals}
\usage{
\method{coefplot}{gllvm}(object, y.label = TRUE, which.Xcoef = NULL,
  cex.ylab = 0.5, mfrow = NULL, mar = c(4, 6, 2, 1), xlim.list = NULL,
  ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{y.label}{logical, if \code{TRUE} (default) colnames of y with respect to coefficients are added to plot.}

\item{which.Xcoef}{vector indicating which X-coefficients will be plotted. Can be vector of covariate names or numbers. Default is \code{NULL} when all covariate coefficients are plotted.}

\item{cex.ylab}{the magnification to be used for axis annotation relative to the current setting of cex.}

\item{mfrow}{same as \code{mfrow} in \code{par}. If \code{NULL} (default) it is determined automatically.}

\item{mar}{vector of length 4, which defines the margin sizes: \code{c(bottom, left, top, right)}. Defaults to \code{c(4,5,2,1)}.}

\item{xlim.list}{list of vectors with length of two to define the intervals for x axis in each covariate plot. Defaults to NULL when the interval is defined by the range of point estimates and confidence intervals}

\item{...}{additional graphical arguments.}
}
\description{
Plots covariate coefficients and their confidence intervals.
}
\examples{
## Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
X <- as.matrix(antTraits$env)
# Fit model with environmental covariates
fit <- gllvm(y, X, formula = ~ Bare.ground + Shrub.cover,
            family = poisson())
coefplot.gllvm(fit)

\donttest{
# Fit model with all environmental covariates
fitx <- gllvm(y, X, family = "negative.binomial")
coefplot(fitx, mfrow = c(3,2))
coefplot(fitx, which.Xcoef = 1:2)

# Fit gllvm model with environmental and trait covariates
TR <- antTraits$traits
fitT <- gllvm(y = y, X = X, TR = TR, family = "negative.binomial")
coefplot(fitT)
}
}
\author{
Jenni Niku <jenni.m.e.niku@jyu.fi>, Francis K.C. Hui, Sara Taskinen
}
