% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPredictErr.gllvm.R
\name{getPredictErr.gllvm}
\alias{getPredictErr.gllvm}
\alias{getPredictErr}
\title{Extract prediction errors for latent variables from gllvm object}
\usage{
\method{getPredictErr}{gllvm}(object, CMSEP = TRUE, ...)
}
\arguments{
\item{object}{an object of class 'gllvm'.}

\item{CMSEP}{logical, if \code{TRUE} conditional mean squared errors for predictions are calculated. If \code{FALSE}, prediction errors are based on covariances of the variational distributions for \code{method ="VA"}.}

\item{...}{not used}
}
\value{
Function returns following components:
 \item{lvs }{prediction errors for latent variables}
 \item{row.effects }{prediction errors for random row effects if included}
}
\description{
Calculates the prediction errors for latent variables for gllvm model.
}
\details{
Calculates conditional mean squared errors for predictions.
If variational approximation is used, prediction errors can be based on covariances 
of the variational distributions, and therefore they do not take into account 
the uncertainty in the estimation of (fixed) parameters.
}
\examples{
\dontrun{
# Load a dataset from the mvabund package
data(antTraits)
y <- as.matrix(antTraits$abund)
# Fit gllvm model
fit <- gllvm(y = y, family = poisson())
# prediction errors for latent variables:
getPredictErr(fit)
}

}
\author{
Francis K.C. Hui, Jenni Niku, David I. Warton
}
