% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{races}
\alias{races}
\title{Hill races in Scotland}
\format{
A data frame with 35 rows and 4 variables:
\describe{
  \item{race}{a character vector giving the names of the races.}
  \item{distance}{a numeric vector giving the distance, in miles, of the races.}
  \item{cclimb}{a numeric vector giving the cumulative climb, in thousands of feet, of the races.}
  \item{rtime}{a numeric vector giving the record time, in minutes, of the races.}
}
}
\usage{
data(races)
}
\description{
Each year the Scottish Hill Runners Association publishes
a list of hill races in Scotland for the year. These data consist of
the record time, distance, and cumulative climb of 35 of those races.
The statistical analysis of these data aims to explain the differences
between the record time of the races. This is done using their
differences in distance and cumulative climb.
}
\examples{
data(races)
breaks <- with(races,quantile(cclimb,probs=c(0:2)/2))
labels <- c("low","high")
races2 <- within(races,cli <- cut(cclimb,include.lowest=TRUE,breaks,labels))
dev.new()
with(races2,plot(log(distance),log(rtime),pch=16,col=as.numeric(cli)))
legend("topleft", legend=c("low","high"), title="Cumulative climb",
       col=c(1:2), pch=16, bty="n")
}
\references{
Agresti A. (2015) \emph{Foundations of Linear and Generalized Linear Models}.
John Wiley & Sons, New Jersey.
}
\keyword{datasets}
