% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_voi_doi.r
\name{plot_voi_doi}
\alias{plot_voi_doi}
\title{Line plots of VOI and DOI time series}
\usage{
plot_voi_doi(
  data_voi,
  data_doi,
  type = c("obs", "sad", "trd"),
  measure = c("gini", "hhi", "entropy"),
  locations = "countries",
  smooth = TRUE
)
}
\arguments{
\item{data_voi}{Data exported from \code{export_voi} function.}

\item{data_doi}{Data exported from \code{export_doi} function.}

\item{type}{Object of type \code{character} indicating the type of time
series-column from data_score, takes either \emph{obs}, \emph{sad}, or \emph{trd}. Defaults
to \emph{"obs"}.}

\item{measure}{Object of type \code{character} indicating the DOI measure,
takes either \emph{gini}, \emph{hhi}, or \emph{entropy}. Defaults to \emph{"gini"}.}

\item{locations}{Object of type \code{character} indicating for which
set of locations should be filtered. Defaults to \emph{"countries"}.}

\item{smooth}{Object of type \code{logical} indicating whether the \code{geom_smooth}
function of \code{ggplot2} should be used. Defaults to \code{TRUE}.}
}
\value{
Line plot of VOI and DOI time series as \code{ggplot2} object.
}
\description{
The function uses the outputs of \code{export_voi} and \code{export_doi} to prepare a
parallel time series plot of volume and degree of internationalization
values. When the output includes more than one keyword, only the first
keyword is used.
}
\examples{
\dontrun{
data1 <- export_voi(keyword = "manchester united")
data2 <- export_doi(
  keyword = "manchester united",
  locations = "countries"
)
plot_voi_doi(
  data_voi = data1,
  data_doi = data2,
  type = "obs",
  measure = "gini",
  smooth = TRUE
)
plot_voi_doi(
  data_voi = data1,
  data_doi = data2,
  type = "sad",
  measure = "hhi",
  smooth = FALSE
)
plot_voi_doi(
  data_voi = data1,
  data_doi = data2,
  type = "trd",
  measure = "entropy",
  smooth = TRUE
)
}

}
\seealso{
\itemize{
\item \code{\link[=export_voi]{export_voi()}}
\item \code{\link[=export_doi]{export_doi()}}
\item \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
}
}
