% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlorenz.R
\name{tlorenz}
\alias{tlorenz}
\title{Compute relevant probabilities and estimates for selecting performance criteria}
\usage{
tlorenz(q, d1, group, d2, newwts = "newwts")
}
\arguments{
\item{q}{1-percentile of data on variable of interest in group with higher mean value}

\item{d1}{dataset of group with higher mean value.}

\item{group}{variable of interest. Entered in quotes.Must be present in d1 and d2}

\item{d2}{dataset of group with lower mean value.}

\item{newwts}{sampling weights. "newwts" by default. Must be present in data and edata.}
}
\value{
Transformed Lorenz function value for q
}
\description{
Compute relevant probabilities and estimates for selecting performance criteria
}
\examples{
df_samp <- data.frame(x1 = rnorm(500, mean = 5, sd = 2),newwts = rep(1, 500))
df_samp2 <- data.frame(x1 = rnorm(500, mean = 4.5, sd = 2),newwts = rep(1, 500))
p_vals <- seq(0, 1, length.out = 100)
lc_vals <- tlorenz(p_vals, d1 = df_samp, group = "x1", d2 = df_samp2)

#Creates transformed Lorenz curve values for two sets of simulated data
}
