\name{getRowPrimGLPK}
\alias{getRowPrimGLPK}
\alias{glp_get_row_prim}

\title{
  Retrieve Row Primal Value
}

\description{
  Low level interface function to the GLPK function \code{glp_get_row_prim}.
  Consult the GLPK documentation for more detailed information.
}

\usage{
  getRowPrimGLPK(lp, i)
}

\arguments{
  \item{lp}{
    A pointer to a GLPK problem object.
  }
  \item{i}{
    Row number \code{i}.
  }
}

\details{
  Interface to the C function \code{getRowPrim} which calls the GLPK
  function \code{glp_get_row_prim}.
}

\value{
  Row primal value
}

\references{
  Based on the package \pkg{glpk} by Lopaka Lee.
    
  The GNU GLPK home page at \url{http://www.gnu.org/software/glpk/glpk.html}.
}

\author{
  Gabriel Gelius-Dietrich

  Maintainer: Gabriel Gelius-Dietrich <geliudie@uni-duesseldorf.de>
}

\keyword{ optimize }
