% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{export}
\alias{export}
\alias{export.Music}
\title{Export Object}
\usage{
export(x, dir_path, file_name, formats)

\method{export}{Music}(x, dir_path, file_name, formats)
}
\arguments{
\item{x}{An object.}

\item{dir_path}{A single character which specifies the directory to
which to export the object.}

\item{file_name}{A single character which specifies the name of the
exported file(s).}

\item{formats}{A character vector which specifies the file formats.
Supported file formats are "mscz", "mscx", "pdf", "png", "svg", "wav",
"mp3", "flac", "ogg", "midi", "mid", "musicxml", "mxl", "xml", "metajson",
"mlog", "mpos" and "spos".}
}
\value{
Invisible \code{NULL}.

Files with name \code{file_name} and with extensions
\code{formats} are generated in \code{dir_path}.
}
\description{
Export an object to various file formats.
}
\section{Methods (by class)}{
\itemize{
\item \code{Music}: export a \code{Music} object.
}}

\examples{
if (interactive()) {
  m <- Music() + Meter(4, 4) + Line(list("C4"), list(4))
  export(m, tempdir(), "x", c("mp3", "png"))
}
}
