% Generated by roxygen2 (4.0.2.9000): do not edit by hand
% Please edit documentation in R/message.R
\name{import_message}
\alias{import_message}
\title{Import a message into the gmail mailbox from a mime message}
\usage{
import_message(mail, user_id = "me", label_ids = NULL,
  type = c("multipart", "media", "resumable"),
  internal_date_source = c("dateHeader", "recievedTime"))
}
\arguments{
\item{mail}{mime mail message created by mime}

\item{user_id}{gmail user_id to access, special value of 'me' indicates the authenticated user.}

\item{label_ids}{optional label ids to apply to the message}

\item{type}{the type of upload to perform}

\item{internal_date_source}{whether to date the object based on the date of
the message or when it was received by gmail.}
}
\description{
Import a message into the gmail mailbox from a mime message
}
\examples{
\dontrun{
import_message(mime(from="you@me.com", to="any@one.com",
                          subject='hello", "how are you doing?"))
}
}
\references{
\url{https://developers.google.com/gmail/api/v1/reference/users/messages/import}
}

