% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mime.R
\name{gm_mime}
\alias{gm_mime}
\alias{gm_to.mime}
\alias{gm_from.mime}
\alias{gm_cc.mime}
\alias{gm_bcc.mime}
\alias{gm_subject.mime}
\alias{gm_text_body}
\alias{gm_html_body}
\alias{gm_attach_part}
\alias{gm_attach_file}
\title{Create a mime formatted message object}
\usage{
gm_mime(..., attr = NULL, body = NULL, parts = list())

\method{gm_to}{mime}(x, val, ...)

\method{gm_from}{mime}(x, val, ...)

\method{gm_cc}{mime}(x, val, ...)

\method{gm_bcc}{mime}(x, val, ...)

\method{gm_subject}{mime}(x, val, ...)

gm_text_body(
  mime,
  body,
  content_type = "text/plain",
  charset = "utf-8",
  encoding = "quoted-printable",
  format = "flowed",
  ...
)

gm_html_body(
  mime,
  body,
  content_type = "text/html",
  charset = "utf-8",
  encoding = "base64",
  ...
)

gm_attach_part(mime, part, id = NULL, ...)

gm_attach_file(mime, filename, type = NULL, id = NULL, ...)
}
\arguments{
\item{...}{additional parameters to put in the attr field}

\item{attr}{attributes to pass to the message}

\item{body}{Message body.}

\item{parts}{mime parts to pass to the message}

\item{x}{the object whose fields you are setting}

\item{val}{the value to set, can be a vector, in which case the values will be joined by ", ".}

\item{mime}{message.}

\item{content_type}{The content type to use for the body.}

\item{charset}{The character set to use for the body.}

\item{encoding}{The transfer encoding to use for the body.}

\item{format}{The mime format to use for the body.}

\item{part}{Message part to attach}

\item{id}{The content ID of the attachment}

\item{filename}{name of file to attach}

\item{type}{mime type of the attached file}
}
\description{
These functions create a MIME message. They can be created atomically using
\code{gm_mime()} or iteratively using the various accessors.
}
\examples{
# using the field functions
msg = gm_mime() \%>\%
 gm_from("james.f.hester@gmail.com") \%>\%
 gm_to("asdf@asdf.com") \%>\%
 gm_text_body("Test Message")

# alternatively you can set the fields using gm_mime(), however you have
#  to use properly formatted MIME names
msg = gm_mime(From="james.f.hester@gmail.com",
                   To="asdf@asdf.com") \%>\%
        gm_html_body("<b>Test<\b> Message")
}
\concept{mime}
