% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder.R
\name{reorder}
\alias{reorder}
\title{Reorder the variables and the mixture components of a Gaussian mixture model}
\usage{
reorder(gmm, var = NULL, comp = NULL)
}
\arguments{
\item{gmm}{An object of class \code{gmm}.}

\item{var}{A character vector containing the variables in the desired order.
If variables are not specified, they are added after the ordered ones. If
\code{NULL} (the default), the variables are not reordered.}

\item{comp}{An integer vector containing the indexes of the mixture component
in the desired order. If components are not specified, they are added after
the ordered ones. If \code{NULL} (the default), the components are not
reordered.}
}
\value{
The reordered \code{gmm} object.
}
\description{
This function reorders the variables and the mixture components of a Gaussian
mixture model.
}
\examples{
data(gmm_body)
gmm_1 <- reorder(gmm_body, var = c("WAIST", "AGE", "FAT", "HEIGHT", "WEIGHT"),
                 comp = c(2, 1, 3))

}
