% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gompertz_mle.R
\name{gompertz_mle}
\alias{gompertz_mle}
\title{Gompertz MLE function}
\usage{
gompertz_mle(
  formula,
  left_trunc = 1975,
  right_trunc = 2005,
  data,
  byear = byear,
  dyear = dyear,
  lower_age_bound = NULL,
  upper_age_bound = NULL,
  weights = NULL,
  start = NULL,
  death_age_data_type = "auto",
  maxiter = 10000
)
}
\arguments{
\item{formula}{the estimation formula}

\item{left_trunc}{left truncation year}

\item{right_trunc}{right truncation year}

\item{data}{a data frame containing variables in the model}

\item{byear}{vector of birth years}

\item{dyear}{vector of death years}

\item{lower_age_bound}{lowest age at death to include (optional)}

\item{upper_age_bound}{highest age at death to include (optional)}

\item{weights}{an optional vector of individual weights}

\item{start}{an optional vector of starting values for the optimizer. must be
a numeric vector that exactly matches the output of
\code{get.par.start(formula, data)} in length and element names.}

\item{death_age_data_type}{option for handling of continuous and discrete
death age variable (not yet implemented)}

\item{maxiter}{maximum number of iterations for optimizer}
}
\value{
Returns a named list consisting of the following components
(See \code{\link[stats:optim]{stats::optim()}} for additional details):
\describe{
\item{\code{starting_values}}{list of starting values of parameters}
\item{\code{optim_fit}}{A list consisting of:
\describe{
\item{\code{par}}{best estimation of parameter values}
\item{\code{value}}{log likelihood}
\item{\code{counts}}{number of calls to function and gradient}
\item{\code{convergence}}{returns 0 if the model converged, for other values see \code{\link[stats:optim]{stats::optim()}} }
\item{\code{message}}{any other information returned by optimizer}
\item{\code{hessian}}{Hessian matrix}
}
}
\item{\code{results}}{A table of estimates and upper/lower bounds of the 95 percent confidence interval
for the estimates. Confidence interval computed as 1.96*standard_error.}
}
}
\description{
Fits a Gompertz distribution with proportional hazards
to doubly-truncated mortality data using maximum likelihood estimation.
}
\examples{
#model hazards as function of birthplace using bunmd_demo file
demo_dataset <- dplyr::filter(bunmd_demo, bpl_string \%in\% c("Cuba", "England"))

gompertz_mle(formula = death_age ~ bpl_string, left_trunc = 1988, right_trunc = 2005,
data = demo_dataset)

}
