% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga_v4_get.R
\name{google_analytics_4}
\alias{google_analytics_4}
\title{Get Google Analytics v4 data (single request)}
\usage{
google_analytics_4(viewId, date_range = NULL, metrics = NULL,
  dimensions = NULL, dim_filters = NULL, met_filters = NULL,
  filtersExpression = NULL, order = NULL, segments = NULL,
  pivots = NULL, cohorts = NULL, max = 1000,
  samplingLevel = c("DEFAULT", "SMALL", "LARGE"), metricFormat = NULL,
  histogramBuckets = NULL, anti_sample = FALSE,
  anti_sample_batches = "auto", slow_fetch = FALSE)
}
\arguments{
\item{viewId}{viewId of data to get.}

\item{date_range}{character or date vector of format \code{c(start, end)} or 
for two date ranges: \code{c(start1,end1,start2,end2)}}

\item{metrics}{Metric to fetch. Supports calculated metrics.}

\item{dimensions}{Dimensions to fetch.}

\item{dim_filters}{A \link{filter_clause_ga4} wrapping \link{dim_filter}}

\item{met_filters}{A \link{filter_clause_ga4} wrapping \link{met_filter}}

\item{filtersExpression}{A v3 API style simple filter string. Not used with other filters.}

\item{order}{An \link{order_type} object}

\item{segments}{List of segments as created by \link{segment_ga4}}

\item{pivots}{Pivots of the data as created by \link{pivot_ga4}}

\item{cohorts}{Cohorts created by \link{make_cohort_group}}

\item{max}{Maximum number of rows to fetch. Defaults at 1000. Use -1 to fetch all results. Ignored when \code{anti_sample=TRUE}.}

\item{samplingLevel}{Sample level}

\item{metricFormat}{If supplying calculated metrics, specify the metric type}

\item{histogramBuckets}{For numeric dimensions such as hour, a list of buckets of data.
See details in \link{make_ga_4_req}}

\item{anti_sample}{If TRUE will split up the call to avoid sampling.}

\item{anti_sample_batches}{"auto" default, or set to number of days per batch. 1 = daily.}

\item{slow_fetch}{For large results this slows down the API requests to avoid 500 errors}
}
\value{
A Google Analytics data.frame
}
\description{
A convenience function that wraps \link{make_ga_4_req} and \link{fetch_google_analytics_4}
 for the common case of one GA data request.
 
Will perform automatic batching if over the 10000 row per API call limit.
}
\section{Anti-sampling}{


\code{anti_sample} being TRUE ignores \code{max} as the API call is split over days 
  to mitigate the sampling session limit, in which case a row limit won't work.  Take the top rows
  of the result yourself instead e.g. \code{head(ga_data_unsampled, 50300)}

If you are lucky enough to need sub-day sampling, it will attempt to fetch per hour, but you are
  restricted to not using \code{dim_filter} argument if this is the case.  
  Try using \code{filtersExpression} instead.
  
\code{anti_sample} being TRUE will also set \code{samplingLevel='LARGE'} to minimise 
  the number of calls.
}

\examples{

\dontrun{
library(googleAnalyticsR)

## authenticate, or use the RStudio Addin "Google API Auth" with analytics scopes set

ga_auth()

## get your accounts

account_list <- google_analytics_account_list()

## account_list will have a column called "viewId"
account_list$viewId

## View account_list and pick the viewId you want to extract data from
ga_id <- 123456

## simple query to test connection
google_analytics_4(ga_id, 
                   date_range = c("2017-01-01", "2017-03-01"), 
                   metrics = "sessions", 
                   dimensions = "date")

}

}
\seealso{
Other GAv4 fetch functions: \code{\link{fetch_google_analytics_4_slow}},
  \code{\link{fetch_google_analytics_4}},
  \code{\link{make_ga_4_req}}
}
