% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{cr_deploy_packagetests}
\alias{cr_deploy_packagetests}
\title{Deploy a cloudbuild.yml for R package tests and upload to Codecov}
\usage{
cr_deploy_packagetests(
  steps = NULL,
  cloudbuild_file = "cloudbuild-tests.yml",
  env = c("NOT_CRAN=true"),
  test_script = NULL,
  codecov_script = NULL,
  codecov_token = "$_CODECOV_TOKEN",
  build_image = "gcr.io/gcer-public/packagetools:master",
  ...
)
}
\arguments{
\item{steps}{extra steps to run before the \link{cr_buildstep_packagetests} steps run (such as decryption of auth files)}

\item{cloudbuild_file}{The cloudbuild yaml file to write to}

\item{env}{Environment arguments to be set during the test script runs}

\item{test_script}{The script that will run first making tests.  If \code{NULL} a default script it used}

\item{codecov_script}{The script that will run first making tests.  If \code{NULL} a default script it used}

\item{codecov_token}{If using codecov, supply your codecov token here. Default assumes you add it to the Cloud Build substitution macros, which is more secure and recommended.}

\item{build_image}{The docker image that will be used to run the R code for the test scripts}

\item{...}{Other arguments passed to \link{cr_build_make}}
}
\description{
This tests an R package each time you commit, and uploads the test coverage results to Codecov
}
\details{
The trigger repository needs to hold an R package configured to do tests upon.

For GitHub, the repository will need to be linked to the project you are building within, via \url{https://console.cloud.google.com/cloud-build/triggers/connect}

If your tests need authentication details, add these via \link{cr_buildstep_decrypt} to the \code{steps} argument, which will prepend decrypting the authentication file before running the tests.

If you want codecov to ignore some files then also deploy a .covrignore file to your repository - see covr website at \url{https://covr.r-lib.org/} for details.
}
\examples{

pd <- cr_deploy_packagetests()
pd

# add a decryption step for an auth file
cr_deploy_packagetests(
  steps = cr_buildstep_secret("my_secret", "auth.json"),
  env = c("NOT_CRAN=true", "MY_AUTH_FILE=auth.json"),
  timeout = 1200
)

unlink("cloudbuild-tests.yml")

}
\seealso{
Create your own custom deployment using \link{cr_buildstep_packagetests} which this function uses with some defaults

Other Deployment functions: 
\code{\link{cr_deploy_docker}()},
\code{\link{cr_deploy_git_html}()},
\code{\link{cr_deploy_github_docker}()},
\code{\link{cr_deploy_pkgdown}()},
\code{\link{cr_deploy_run}()},
\code{\link{cr_deploy_r}()}
}
\concept{Deployment functions}
