% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_admin.R
\name{cr_build_artifacts}
\alias{cr_build_artifacts}
\title{Download artifacts from a build}
\usage{
cr_build_artifacts(
  build,
  download_folder = getwd(),
  overwrite = FALSE,
  path_regex = NULL
)
}
\arguments{
\item{build}{A \link{Build} object that includes the artifact location}

\item{download_folder}{Where to download the artifact files}

\item{overwrite}{Whether to overwrite existing local data}

\item{path_regex}{A regex of files to fetch from the artifact bucket location.  This is due to not being able to support the path globs}
}
\description{
If a completed build includes artifact files this downloads them to local files
}
\details{
If your artifacts are using file glob (e.g. \code{myfolder/**}) to decide which workspace files are uploaded to Cloud Storage, you will need to create a path_regex of similar functionality (\code{"^myfolder/"}).  This is not needed if you use absolute path names such as \code{"myfile.csv"}
}
\examples{
\dontrun{
#' r <- "write.csv(mtcars,file = 'artifact.csv')"
ba <- cr_build_yaml(
  steps = cr_buildstep_r(r),
  artifacts = cr_build_yaml_artifact("artifact.csv", bucket = "my-bucket")
)
ba

build <- cr_build(ba)
built <- cr_build_wait(build)

cr_build_artifacts(built)
}

}
\seealso{
\href{https://cloud.google.com/build/docs/building/store-build-artifacts}{Storing images and artifacts}

Other Cloud Build functions: 
\code{\link{Build}()},
\code{\link{RepoSource}()},
\code{\link{Source}()},
\code{\link{StorageSource}()},
\code{\link{cr_build_list}()},
\code{\link{cr_build_logs}()},
\code{\link{cr_build_make}()},
\code{\link{cr_build_status}()},
\code{\link{cr_build_targets}()},
\code{\link{cr_build_upload_gcs}()},
\code{\link{cr_build_wait}()},
\code{\link{cr_build_write}()},
\code{\link{cr_build_yaml_artifact}()},
\code{\link{cr_build_yaml_secrets}()},
\code{\link{cr_build_yaml}()},
\code{\link{cr_build}()}
}
\concept{Cloud Build functions}
