% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables_builtin.R
\name{gtm_builtin_revert}
\alias{gtm_builtin_revert}
\title{Reverts changes to a GTM Built-In Variables in a GTM Workspace}
\usage{
gtm_builtin_revert(account_id, container_id, workspace_id, variable)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{variable}{A built-in Variable or list of built-in variables. Valid values are here \code{\link{variables_list}}}
}
\description{
This reeverts any changes to a GTM Built-In Variables in a GTM Workspace.
}
\examples{
\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
variable <- 'clickId'

variable <- gtm_variables_revert(accountId, containerId, workspaceId, variable)

# Changes to variable 22 have been reverted
}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/built_in_variables/revert}

Other built in variable functions: 
\code{\link{gtm_builtin_create}()},
\code{\link{gtm_builtin_delete}()},
\code{\link{gtm_builtin_list}()},
\code{\link{variables_list}}
}
\concept{built in variable functions}
