% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{gtm_zones_delete}
\alias{gtm_zones_delete}
\title{Delete a zone}
\usage{
gtm_zones_delete(
  account_id,
  container_id,
  workspace_id,
  zone_id,
  force = c("TRUE", "FALSE")
)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{zone_id}{Zone Id}

\item{force}{Force deletion without user input}
}
\description{
This deletes a zone in a GTM workspace
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 11
zoneId <- 3

gtm_zones_delete(accountId, containerId, workspaceId, zoneId, "TRUE")

}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/zones/delete}

Other zone functions: 
\code{\link{gtm_zones_create}()},
\code{\link{gtm_zones_get}()},
\code{\link{gtm_zones_list}()},
\code{\link{gtm_zones_revert}()},
\code{\link{gtm_zones_update}()}
}
\concept{zone functions}
