% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_delete.R
\name{gs_grepdel}
\alias{gs_grepdel}
\alias{gs_vecdel}
\title{Delete several spreadsheets at once by title}
\usage{
gs_grepdel(regex, ..., verbose = TRUE)

gs_vecdel(vec, verbose = TRUE)
}
\arguments{
\item{regex}{character; a regular expression; sheets whose titles match will
be deleted}

\item{...}{optional arguments to be passed to \code{\link{grep}} when
matching \code{regex} to sheet titles}

\item{verbose}{logical; do you want informative messages?}

\item{vec}{character vector of sheet titles to delete}
}
\description{
These functions violate the general convention of operating on a registered
Google sheet, i.e. on a \code{\link{googlesheet}} object. But the need to
delete a bunch of sheets at once, based on a vector of titles or on a regular
expression, came up so much during development and testing, that it seemed
wise to package this as a function.
}
\examples{
\dontrun{
sheet_title <- c("cat", "catherine", "tomCAT", "abdicate", "FLYCATCHER")
ss <- lapply(paste0("TEST-", sheet_title), gs_new)
# list, for safety!, then delete 'TEST-abdicate' and 'TEST-catherine'
gs_ls(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]+$")
gs_grepdel(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]+$")

# list, for safety!, then delete the rest,
# i.e. 'TEST-cat', 'TEST-tomCAT', and 'TEST-FLYCATCHER'
gs_ls(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]*$", ignore.case = TRUE)
gs_grepdel(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]*$", ignore.case = TRUE)

## using gs_vecdel()
sheet_title <- c("cat", "catherine", "tomCAT", "abdicate", "FLYCATCHER")
ss <- lapply(paste0("TEST-", sheet_title), gs_new)
# delete two of these sheets
gs_vecdel(c("TEST-cat", "TEST-abdicate"))
# see? they are really gone, but the others remain
gs_ls(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]*$", ignore.case = TRUE)
# delete the remainder
gs_vecdel(c("TEST-FLYCATCHER", "TEST-tomCAT", "TEST-catherine"))
# see? they are all gone now
gs_ls(regex = "TEST-[a-zA-Z]*cat[a-zA-Z]*$", ignore.case = TRUE)
}

}
\seealso{
\code{\link{gs_delete}} for more detail on what you can and cannot
delete and how to recover from accidental deletion

Other sheet deletion functions: \code{\link{gs_delete}}
}

