% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_make.R
\name{request_make}
\alias{request_make}
\title{Make a Google Sheets API request}
\usage{
request_make(x, ..., encode = c("json", "multipart", "form", "raw"))
}
\arguments{
\item{x}{List. Holds the components for an HTTP request, presumably created
with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_build]{gargle::request_build()}}. Must contain a
\code{method} and \code{url}. If present, \code{body} and \code{token} are used.}

\item{...}{Optional arguments passed through to the HTTP method.}

\item{encode}{If the body is a named list, how should it be encoded? This is
essentially the same as \code{encode} in all the \code{\link[httr:VERB]{httr::VERB()}}s, except we
choose a different default: a default of \code{encode = "json"} is much more
useful when calling Google APIs.}
}
\value{
Object of class \code{response} from \link{httr}.
}
\description{
Low-level function to execute a Sheets API request. Most users
should, instead, use higher-level wrappers that facilitate common tasks,
such as reading or writing worksheets or cell ranges. The functions here
are intended for internal use and for programming around the Sheets API.

\code{make_request()} does very, very little: it calls an HTTP
method, only adding the googlesheets4 user agent. Typically the input has
been created with \code{\link[=request_generate]{request_generate()}} or \code{\link[gargle:request_build]{gargle::request_build()}} and the
output is processed with \code{process_response()}.
}
\seealso{
Other low-level API functions: 
\code{\link{gs4_has_token}()},
\code{\link{gs4_token}()},
\code{\link{request_generate}()}
}
\concept{low-level API functions}
