% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6-grafos-matriz.R
\encoding{UTF-8}
\name{apply_incidence_map}
\alias{apply_incidence_map}
\title{Apply incidence map of a graph to an edge vector}
\usage{
apply_incidence_map(eG, v)
}
\arguments{
\item{eG}{Graph in edgelist representation, see \link{as_edgelist}.}

\item{v}{Edge vector to which the incidence map will be applied.}
}
\value{
A vertex vector, having the degree of each vertex in the
subgraph specified by the edge vector.
}
\description{
Apply incidence map of a graph to an edge vector.  It uses the
edgelist of the graph instead of the incidence matrix.
}
\details{
The incidence map is the linear transformation from the edge
vector space to the vertex vector space of a graph associating
to each edge its incident vertices.  It is customarily
represented by the incidence matrix, which is a very large
matrix for large graphs; for this reason it not efficient to
use directly the incidence matrix.  This function uses the
edgelist of the graph as returned by the \link{as_edgelist}
function to compute the result of the incidence map on an edge
vector, which is interpreted with respect to the same
edgelist.
}
\examples{
g <- make_graph("Dodecahedron")
eG <- as_edgelist(g)
set.seed(1)
v <- sample(0:1, gsize(g), replace = TRUE) # Random edge vector
apply_incidence_map(eG, v) # 1 1 0 1 2 0 1 1 3 2 0 1 1 1 1 1 0 0 1 2
## Plotting the associated subgraph
h <- make_graph(t(eG[v==1,]))
z <- layout_with_gem(g)
plot(g, layout = z)
plot(h, layout = z, add = TRUE, edge.color = "red3", edge.width = 3)

}
\seealso{
\link{shave_cycle}, for shaving hairy cycles, which makes use
of this routine, and \link{generate_fundamental_cycles}, using the
former.
}
\author{
Cesar Asensio
}
