% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{GPModel_shared_params}
\alias{GPModel_shared_params}
\title{Shared parameter docs}
\arguments{
\item{likelihood}{A \code{string} specifying the likelihood function (distribution) of the response variable
Default = "gaussian"}

\item{group_data}{A \code{vector} or \code{matrix} with elements being group levels for defining 
grouped random effects. I.e., this is either a \code{vector} consisting of a 
categorical variable or a \code{matrix} whose columns are categorical variables.
The elements of 'group_data' can be integer, double, or character.}

\item{group_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data 
for grouped random coefficients}

\item{ind_effect_group_rand_coef}{A \code{vector} with integer indices that 
indicate the corresponding random effects (=columns) in 'group_data' for 
every covariate in 'group_rand_coef_data'. Counting starts at 1.
The length of this index vector must equal the number of covariates in 'group_rand_coef_data'.
For instance, c(1,1,2) means that the first two covariates (=first two columns) in 'group_rand_coef_data'
have random coefficients corresponding to the first random effect (=first column) in 'group_data',
and the third covariate (=third column) in 'group_rand_coef_data' has a random coefficient
corresponding to the second random  effect (=second column) in 'group_data'.}

\item{gp_coords}{A \code{matrix} with numeric coordinates (=features) for defining Gaussian processes}

\item{gp_rand_coef_data}{A \code{vector} or \code{matrix} with numeric covariate data for
Gaussian process random coefficients}

\item{cov_function}{A \code{string} specifying the covariance function for the Gaussian process. 
The following covariance functions are available:
"exponential", "gaussian", "matern", "powered_exponential", "wendland", and "exponential_tapered".
For "exponential", "gaussian", and "powered_exponential", we follow the notation and parametrization of Diggle and Ribeiro (2007).
For "matern", we follow the notation of Rassmusen and Williams (2006).
For "wendland", we follow the notation of Bevilacqua et al. (2019).
A covariance function with the suffix "_tapered" refers to a covariance function that is multiplied by 
a compactly supported Wendland covariance function (= tapering)}

\item{cov_fct_shape}{A \code{numeric} specifying the shape parameter of the covariance function 
(=smoothness parameter for Matern and Wendland covariance). For the Wendland covariance function, 
we follow the notation of Bevilacqua et al. (2019)). 
This parameter is irrelevant for some covariance functions such as the exponential or Gaussian.}

\item{cov_fct_taper_range}{A \code{numeric} specifying the range parameter of the Wendland covariance function / taper. We follow the notation of Bevilacqua et al. (2019)}

\item{vecchia_approx}{A \code{boolean}. If TRUE, the Vecchia approximation is used}

\item{num_neighbors}{An \code{integer} specifying the number of neighbors for the Vecchia approximation}

\item{vecchia_ordering}{A \code{string} specifying the ordering used in the Vecchia approximation. 
"none" means the default ordering is used, "random" uses a random ordering}

\item{vecchia_pred_type}{A \code{string} specifying the type of Vecchia approximation used for making predictions. 
"order_obs_first_cond_obs_only" = observed data is ordered first and the neighbors are only observed points, 
"order_obs_first_cond_all" = observed data is ordered first and the neighbors are selected among all points 
(observed + predicted), "order_pred_first" = predicted data is ordered first for making predictions, 
"latent_order_obs_first_cond_obs_only" = Vecchia approximation for the latent process and observed data is 
ordered first and neighbors are only observed points, "latent_order_obs_first_cond_all" = Vecchia approximation 
for the latent process and observed data is ordered first and neighbors are selected among all points}

\item{num_neighbors_pred}{an \code{integer} specifying the number of neighbors for the Vecchia approximation 
for making predictions}

\item{cluster_ids}{A \code{vector} with elements indicating independent realizations of 
random effects / Gaussian processes (same values = same process realization).
The elements of 'cluster_ids' can be integer, double, or character.}

\item{free_raw_data}{A \code{boolean}. If TRUE, the data (groups, coordinates, covariate data for random coefficients) 
is freed in R after initialization}

\item{y}{A \code{vector} with response variable data}

\item{X}{A \code{matrix} with numeric covariate data for the 
fixed effects linear regression term (if there is one)}

\item{params}{A \code{list} with parameters for the model fitting / optimization
 \itemize{
    \item{optimizer_cov}{ Optimizer used for estimating covariance parameters. 
    Options: "gradient_descent", "fisher_scoring", "nelder_mead", and "bfgs".
    Default= gradient_descent"}
    \item{optimizer_coef}{ Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent", "wls", "nelder_mead", and "bfgs". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance parameters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    Default="wls" for Gaussian data and "gradient_descent" for other likelihoods.
    If 'optimizer_cov' is set to "nelder_mead" or "bfgs", 'optimizer_coef' is automatically also set to the same value.}
    \item{maxit}{ Maximal number of iterations for optimization algorithm. Default=1000}
    \item{delta_rel_conv}{ Convergence tolerance. The algorithm stops if the relative change 
    in eiher the (approximate) log-likelihood or the parameters is below this value. 
    For "bfgs", the L2 norm of the gradient is used instead of the relative change in the log-likelihood. 
    Default=1E-6}
    \item{convergence_criterion}{ The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" (default) or "relative_change_in_parameters"}
    \item{init_coef}{ Initial values for the regression coefficients (if there are any, can be NULL).
    Default=NULL}
    \item{init_cov_pars}{ Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). Default=NULL}
    \item{lr_coef}{ Learning rate for fixed effect regression coefficients if gradient descent is used.
    Default=0.1}
    \item{lr_cov}{ Learning rate for covariance parameters. If <= 0, internal default values are used.
    Default value = 0.1 for "gradient_descent" and 1. for "fisher_scoring"}
    \item{use_nesterov_acc}{ If TRUE Nesterov acceleration is used.
    This is used only for gradient descent. Default=TRUE}
    \item{acc_rate_coef}{ Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration. Default=0.5}
    \item{acc_rate_cov}{ Acceleration rate for covariance parameters for Nesterov acceleration.
    Default=0.5}
    \item{momentum_offset}{ Number of iterations for which no momentum is applied in the beginning.
    Default=2}
    \item{trace}{ If TRUE, information on the progress of the parameter
    optimization is printed. Default=FALSE}
    \item{std_dev}{ If TRUE, (asymptotic) standard deviations are calculated for the covariance parameters}
}}

\item{fixed_effects}{A \code{vector} of optional external fixed effects which are held fixed during training.}

\item{group_data_pred}{A \code{vector} or \code{matrix} with elements being group levels 
for which predictions are made (if there are grouped random effects in the \code{GPModel})}

\item{group_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data 
for grouped random coefficients (if there are some in the \code{GPModel})}

\item{gp_coords_pred}{A \code{matrix} with prediction coordinates (=features) for 
Gaussian process (if there is a GP in the \code{GPModel})}

\item{gp_rand_coef_data_pred}{A \code{vector} or \code{matrix} with covariate data for 
Gaussian process random coefficients (if there are some in the \code{GPModel})}

\item{cluster_ids_pred}{A \code{vector} with elements indicating the realizations of 
random effects / Gaussian processes for which predictions are made 
(set to NULL if you have not specified this when creating the \code{GPModel})}

\item{X_pred}{A \code{matrix} with prediction covariate data for the 
fixed effects linear regression term (if there is one in the \code{GPModel})}

\item{predict_cov_mat}{A \code{boolean}. If TRUE, the (posterior / conditional) 
predictive covariance is calculated in addition to the (posterior / conditional) predictive mean}

\item{predict_var}{A \code{boolean}. If TRUE, the (posterior / conditional) 
predictive variances are calculated}
}
\description{
Parameter docs shared by \code{GPModel}, \code{gpb.cv}, and \code{gpboost}
}
