% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anthropic.R
\name{create_completion_anthropic}
\alias{create_completion_anthropic}
\title{Generate text completions using Anthropic's API}
\usage{
create_completion_anthropic(
  prompt,
  history = NULL,
  model = "claude-1",
  max_tokens_to_sample = 256,
  key = Sys.getenv("ANTHROPIC_API_KEY")
)
}
\arguments{
\item{prompt}{The prompt for generating completions}

\item{history}{A list of the previous chat responses}

\item{model}{The model to use for generating text. By default, the
function will try to use "claude-1".}

\item{max_tokens_to_sample}{The maximum number of tokens to generate. Defaults to 256.}

\item{key}{The API key for accessing Anthropic's API. By default, the
function will try to use the \code{ANTHROPIC_API_KEY} environment variable.}
}
\value{
A list with the generated completions and other information returned
by the API.
}
\description{
Generate text completions using Anthropic's API
}
\examples{
\dontrun{
create_completion_anthropic(
  prompt = "\n\nHuman: Hello, world!\n\nAssistant:",
  model = "claude-1",
  max_tokens_to_sample = 256
)
}
}
